/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap;

import org.ehcache.impl.internal.store.offheap.MemorySizeParser;
import org.ehcache.impl.internal.store.offheap.OffHeapStoreUtils;
import org.ehcache.shadow.org.terracotta.offheapstore.util.DebuggingUtils;

public class HeuristicConfiguration {
    private static final String MINIMUM_MAX_MEMORY = "1M";
    private static final long MINIMUM_MAX_MEMORY_IN_BYTES = MemorySizeParser.parse("1M");
    private static final int IDEAL_MAX_SEGMENT_SIZE = 0x2000000;
    private static final int MAXIMUM_CHUNK_SIZE = 0x40000000;
    private static final int MINIMUM_SEGMENT_COUNT = 16;
    private static final int MAXIMUM_SEGMENT_COUNT = 16384;
    private static final int MAXIMAL_SEGMENT_SIZE_RATIO = 4;
    private static final int INITIAL_SEGMENT_SIZE_RATIO = 16;
    private static final int ASSUMED_KEY_VALUE_SIZE = 1024;
    private static final int AGGRESSIVE_INITIAL_SEGMENT_SIZE_RATIO = 1;
    private final long maximumSize;
    private final int idealMaxSegmentSize;
    private final int maximumChunkSize;
    private final int minimumSegmentCount;
    private final int maximumSegmentCount;
    private final int maximalSegmentSizeRatio;
    private final int initialSegmentSizeRatio;
    private final int assumedKeyValueSize;

    public HeuristicConfiguration(long maximumSize) {
        if (maximumSize < MINIMUM_MAX_MEMORY_IN_BYTES) {
            throw new IllegalArgumentException("The value of maxBytesLocalOffHeap is less than the minimum allowed value of 1M. Reconfigure maxBytesLocalOffHeap in ehcache.xml or programmatically.");
        }
        this.maximumSize = maximumSize;
        if (OffHeapStoreUtils.getAdvancedBooleanConfigProperty("aggressive", false)) {
            this.idealMaxSegmentSize = (int)OffHeapStoreUtils.getAdvancedMemorySizeConfigProperty("idealMaxSegmentSize", 0x2000000L);
            this.maximumChunkSize = (int)OffHeapStoreUtils.getAdvancedMemorySizeConfigProperty("maximumChunkSize", 0x40000000L);
            this.minimumSegmentCount = (int)OffHeapStoreUtils.getAdvancedMemorySizeConfigProperty("minimumSegmentCount", 16L);
            this.maximumSegmentCount = (int)OffHeapStoreUtils.getAdvancedMemorySizeConfigProperty("maximumSegmentCount", 16384L);
            this.maximalSegmentSizeRatio = (int)OffHeapStoreUtils.getAdvancedMemorySizeConfigProperty("maximalSegmentSizeRatio", 4L);
            this.initialSegmentSizeRatio = (int)OffHeapStoreUtils.getAdvancedMemorySizeConfigProperty("initialSegmentSizeRatio", 1L);
            this.assumedKeyValueSize = (int)OffHeapStoreUtils.getAdvancedMemorySizeConfigProperty("assumedKeyValueSize", 1024L);
        } else {
            this.idealMaxSegmentSize = (int)OffHeapStoreUtils.getAdvancedMemorySizeConfigProperty("idealMaxSegmentSize", 0x2000000L);
            this.maximumChunkSize = (int)OffHeapStoreUtils.getAdvancedMemorySizeConfigProperty("maximumChunkSize", 0x40000000L);
            this.minimumSegmentCount = (int)OffHeapStoreUtils.getAdvancedMemorySizeConfigProperty("minimumSegmentCount", 16L);
            this.maximumSegmentCount = (int)OffHeapStoreUtils.getAdvancedMemorySizeConfigProperty("maximumSegmentCount", 16384L);
            this.maximalSegmentSizeRatio = (int)OffHeapStoreUtils.getAdvancedMemorySizeConfigProperty("maximalSegmentSizeRatio", 4L);
            this.initialSegmentSizeRatio = (int)OffHeapStoreUtils.getAdvancedMemorySizeConfigProperty("initialSegmentSizeRatio", 16L);
            this.assumedKeyValueSize = (int)OffHeapStoreUtils.getAdvancedMemorySizeConfigProperty("assumedKeyValueSize", 1024L);
        }
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    public int getMinimumChunkSize() {
        return (int)Math.min((long)this.maximumChunkSize, (long)this.maximalSegmentSizeRatio * (this.getMaximumSize() / (long)this.getConcurrency()));
    }

    public int getMaximumChunkSize() {
        return (int)Math.min(this.getMaximumSize(), (long)this.maximumChunkSize);
    }

    public int getConcurrency() {
        return Integer.highestOneBit((int)Math.min((long)this.maximumSegmentCount, Math.max((long)this.minimumSegmentCount, this.getMaximumSize() / (long)this.idealMaxSegmentSize)));
    }

    public int getInitialSegmentTableSize() {
        return Math.max(1, this.getSegmentDataPageSize() / this.assumedKeyValueSize);
    }

    public int getSegmentDataPageSize() {
        return Integer.highestOneBit((int)Math.min((long)this.getMinimumChunkSize(), this.getInitialSegmentCapacity() * (long)this.assumedKeyValueSize));
    }

    private long getInitialSegmentCapacity() {
        return this.getMaximumSize() / (long)(this.getConcurrency() * this.initialSegmentSizeRatio * (this.assumedKeyValueSize + 16));
    }

    public String toString() {
        String sb = "Heuristic Configuration: \nMaximum Size (specified)   : " + DebuggingUtils.toBase2SuffixedString(this.getMaximumSize()) + "B\nMinimum Chunk Size         : " + DebuggingUtils.toBase2SuffixedString(this.getMinimumChunkSize()) + "B\nMaximum Chunk Size         : " + DebuggingUtils.toBase2SuffixedString(this.getMaximumChunkSize()) + "B\nConcurrency                : " + this.getConcurrency() + "\nInitial Segment Table Size : " + DebuggingUtils.toBase2SuffixedString(this.getInitialSegmentTableSize()) + " slots\nSegment Data Page Size     : " + DebuggingUtils.toBase2SuffixedString(this.getSegmentDataPageSize()) + "B\n";
        return sb;
    }
}

