/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.SAMLProtocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.handler.RequestHandler;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.cxf.fediz.core.processor.FedizRequest;
import org.apache.cxf.fediz.core.processor.RedirectionResponse;
import org.apache.cxf.fediz.core.spi.ReplyConstraintCallback;
import org.apache.cxf.fediz.core.util.StringUtils;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class LogoutHandler
implements RequestHandler<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(LogoutHandler.class);
    protected final FedizContext fedizConfig;
    private final String servletContextPath;
    private Element token;

    public LogoutHandler(FedizContext fedConfig) {
        this(fedConfig, "/");
    }

    public LogoutHandler(FedizContext fedConfig, String servletContextPath) {
        this.fedizConfig = fedConfig;
        this.servletContextPath = servletContextPath;
    }

    @Override
    public boolean canHandleRequest(HttpServletRequest request) {
        String wa = request.getParameter("wa");
        if ("wsignout1.0".equals(wa) || "wsignoutcleanup1.0".equals(wa)) {
            return true;
        }
        String logoutUrl = this.fedizConfig.getLogoutURL();
        return logoutUrl != null && !logoutUrl.isEmpty() && this.servletContextPath != null && request.getRequestURI().equals(this.servletContextPath + logoutUrl);
    }

    @Override
    public Boolean handleRequest(HttpServletRequest request, HttpServletResponse response) {
        String wa = request.getParameter("wa");
        if ("wsignout1.0".equals(wa)) {
            return this.signout(request, response);
        }
        if ("wsignoutcleanup1.0".equals(wa)) {
            return this.signoutCleanup(request, response);
        }
        if (request.getParameter("SAMLResponse") != null && this.fedizConfig.getProtocol() instanceof SAMLProtocol) {
            return this.handleSAMLSSOLogoutResponse(request, response);
        }
        return this.customLogout(request, response);
    }

    protected boolean customLogout(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("Custom Logout URL was invoked.");
        return this.signout(request, response);
    }

    protected boolean signoutCleanup(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("SignOutCleanup request found. Terminating user session.");
        request.getSession().invalidate();
        String wreply = request.getParameter("wreply");
        String logoutRedirectTo = this.fedizConfig.getLogoutRedirectTo();
        if (wreply != null && !wreply.isEmpty()) {
            Pattern logoutRedirectToConstraint = null;
            try {
                logoutRedirectToConstraint = this.resolveLogoutRedirectToConstraint(request, this.fedizConfig);
            }
            catch (Exception e) {
                LOG.error("Error redirecting user after logout: {}", (Object)e.getMessage());
            }
            if (logoutRedirectToConstraint == null) {
                LOG.debug("No regular expression constraint configured for logout. Ignoring wreply parameter");
            } else {
                Matcher matcher = logoutRedirectToConstraint.matcher(wreply);
                if (matcher.matches()) {
                    try {
                        LOG.debug("Redirecting user after logout to: {}", (Object)wreply);
                        response.sendRedirect(response.encodeRedirectURL(wreply));
                        return true;
                    }
                    catch (IOException e) {
                        LOG.error("Error redirecting user after logout: {}", (Object)e.getMessage());
                    }
                } else {
                    LOG.warn("The received wreply address {} does not match the configured constraint {}", (Object)wreply, (Object)logoutRedirectToConstraint);
                }
            }
        } else if (logoutRedirectTo != null && !logoutRedirectTo.isEmpty()) {
            try {
                if (logoutRedirectTo.startsWith("/")) {
                    logoutRedirectTo = StringUtils.extractFullContextPath(request).concat(logoutRedirectTo.substring(1));
                } else if (!logoutRedirectTo.startsWith("http") && !logoutRedirectTo.startsWith("https")) {
                    logoutRedirectTo = StringUtils.extractFullContextPath(request).concat(logoutRedirectTo);
                }
                LOG.debug("Redirecting after logout to={}", (Object)logoutRedirectTo);
                response.sendRedirect(response.encodeRedirectURL(logoutRedirectTo));
                return true;
            }
            catch (Exception e) {
                LOG.error("Error redirecting user after logout: {}", (Object)e.getMessage());
            }
        }
        this.writeLogoutImage(response);
        return true;
    }

    private Pattern resolveLogoutRedirectToConstraint(HttpServletRequest request, FedizContext config) throws IOException, UnsupportedCallbackException {
        Object logoutConstraintObj = config.getLogoutRedirectToConstraint();
        if (logoutConstraintObj instanceof Pattern) {
            return (Pattern)logoutConstraintObj;
        }
        if (logoutConstraintObj instanceof CallbackHandler) {
            CallbackHandler frCB = (CallbackHandler)logoutConstraintObj;
            ReplyConstraintCallback callback = new ReplyConstraintCallback(request);
            frCB.handle(new Callback[]{callback});
            return callback.getReplyConstraint();
        }
        return null;
    }

    public void setToken(Element token) {
        this.token = token;
    }

    protected boolean signout(HttpServletRequest request, HttpServletResponse response) {
        LOG.debug("SignOut request found. Redirecting to IDP...");
        try {
            FedizProcessor wfProc;
            RedirectionResponse redirectionResponse;
            String redirectURL;
            SamlAssertionWrapper assertionToken = null;
            if (this.token != null) {
                assertionToken = new SamlAssertionWrapper(this.token);
            }
            if ((redirectURL = (redirectionResponse = (wfProc = FedizProcessorFactory.newFedizProcessor(this.fedizConfig.getProtocol())).createSignOutRequest(request, assertionToken, this.fedizConfig)).getRedirectionURL()) != null) {
                Map<String, String> headers = redirectionResponse.getHeaders();
                if (!headers.isEmpty()) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        response.addHeader(entry.getKey(), entry.getValue());
                    }
                }
                response.sendRedirect(redirectURL);
                return true;
            }
            LOG.warn("Failed to create SignOutRequest.");
        }
        catch (Exception ex) {
            LOG.warn("Failed to create SignOutRequest: " + ex.getMessage());
            try {
                response.sendError(500, "Failed to create SignOutRequest.");
            }
            catch (IOException e) {
                LOG.error("Failed to send error response: {}", (Object)e.getMessage());
            }
        }
        return false;
    }

    protected void writeLogoutImage(HttpServletResponse response) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("logout.jpg");
        if (inputStream == null) {
            LOG.warn("Could not write logout.jpg");
            return;
        }
        byte[] buf = new byte[1024];
        try (ServletOutputStream responseOutputStream = response.getOutputStream();){
            int read;
            response.setContentType("image/jpeg");
            while ((read = inputStream.read(buf)) != -1) {
                responseOutputStream.write(buf, 0, read);
            }
            responseOutputStream.flush();
        }
        catch (IOException e) {
            LOG.error("Could not send logout image: {}", (Object)e.getMessage());
        }
    }

    protected boolean handleSAMLSSOLogoutResponse(HttpServletRequest request, HttpServletResponse response) {
        try {
            FedizProcessor wfProc = FedizProcessorFactory.newFedizProcessor(this.fedizConfig.getProtocol());
            FedizRequest wfReq = new FedizRequest();
            wfReq.setResponseToken(request.getParameter("SAMLResponse"));
            wfReq.setState(request.getParameter("RelayState"));
            wfReq.setRequest(request);
            wfReq.setSignOutResponse(true);
            wfProc.processRequest(wfReq, this.fedizConfig);
            String logoutRedirectTo = this.fedizConfig.getLogoutRedirectTo();
            if (logoutRedirectTo != null && !logoutRedirectTo.isEmpty()) {
                try {
                    if (logoutRedirectTo.startsWith("/")) {
                        logoutRedirectTo = StringUtils.extractFullContextPath(request).concat(logoutRedirectTo.substring(1));
                    } else if (!logoutRedirectTo.startsWith("http") && !logoutRedirectTo.startsWith("https")) {
                        logoutRedirectTo = StringUtils.extractFullContextPath(request).concat(logoutRedirectTo);
                    }
                    LOG.debug("Redirecting after logout to={}", (Object)logoutRedirectTo);
                    response.sendRedirect(response.encodeRedirectURL(logoutRedirectTo));
                }
                catch (Exception e) {
                    LOG.error("Error redirecting user after logout: {}", (Object)e.getMessage());
                }
            } else {
                this.writeLogoutImage(response);
            }
            return true;
        }
        catch (ProcessingException ex) {
            LOG.warn("Failed to validate SAMLResponse: " + ex.getMessage());
            this.handleSAMLResponseValidationError(ex, response);
            return false;
        }
    }

    protected void handleSAMLResponseValidationError(ProcessingException ex, HttpServletResponse response) {
        try {
            response.sendError(500, "Failed to validate SAMLResponse.");
        }
        catch (IOException e) {
            LOG.error("Failed to send error response: {}", (Object)e.getMessage());
        }
    }
}

