/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.selector.filter;

import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.filter.Filterable;
import org.apache.activemq.artemis.selector.filter.XPathExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class JAXPXPathEvaluator
implements XPathExpression.XPathEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final XPathFactory FACTORY = XPathFactory.newInstance();
    private final String xpathExpression;
    private final XPath xpath;
    private final DocumentBuilder builder;
    private final XPathExpression compiledXPathExpression;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXPXPathEvaluator(String xpathExpression, DocumentBuilder builder) {
        this.xpathExpression = xpathExpression;
        this.builder = builder;
        XPathFactory xPathFactory = FACTORY;
        synchronized (xPathFactory) {
            this.xpath = FACTORY.newXPath();
        }
        try {
            this.compiledXPathExpression = this.xpath.compile(xpathExpression);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean evaluate(Filterable m) throws FilterException {
        String stringBody = m.getBodyAs(String.class);
        if (stringBody != null) {
            return this.evaluate(stringBody);
        }
        return false;
    }

    protected boolean evaluate(String text) {
        return this.evaluate(new InputSource(new StringReader(text)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean evaluate(InputSource inputSource) {
        try {
            DocumentBuilder documentBuilder = this.builder;
            synchronized (documentBuilder) {
                return (Boolean)this.compiledXPathExpression.evaluate(this.builder.parse(inputSource), XPathConstants.BOOLEAN);
            }
        }
        catch (Exception e) {
            logger.debug("Failed to evaluate XPath expression {}", new Object[]{this.xpathExpression, inputSource, e});
            return false;
        }
    }

    public String toString() {
        return this.xpathExpression;
    }
}

