/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.OperationConsistencyLevel;
import org.apache.activemq.artemis.core.journal.impl.SimpleWaitIOCallback;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.CircularFifoBuffer;

public class OperationContextImpl
implements OperationContext {
    private static final ThreadLocal<OperationContext> threadLocalContext = new ThreadLocal();
    LinkedList<TaskHolder> tasks;
    LinkedList<IgnoreReplicationTaskHolder> ignoreReplicationTasks;
    LinkedList<StoreOnlyTaskHolder> storeOnlyTasks;
    static final AtomicIntegerFieldUpdater<OperationContextImpl> EXECUTORS_PENDING_UPDATER = AtomicIntegerFieldUpdater.newUpdater(OperationContextImpl.class, "executorsPendingField");
    static final AtomicLongFieldUpdater<OperationContextImpl> STORE_LINEUP_UPDATER = AtomicLongFieldUpdater.newUpdater(OperationContextImpl.class, "storeLineUpField");
    static final AtomicLongFieldUpdater<OperationContextImpl> REPLICATION_LINEUP_UPDATER = AtomicLongFieldUpdater.newUpdater(OperationContextImpl.class, "replicationLineUpField");
    static final AtomicLongFieldUpdater<OperationContextImpl> PAGE_LINEUP_UPDATER = AtomicLongFieldUpdater.newUpdater(OperationContextImpl.class, "pageLineUpField");
    volatile int executorsPendingField = 0;
    volatile long storeLineUpField = 0L;
    volatile long replicationLineUpField = 0L;
    volatile long pageLineUpField = 0L;
    long stored = 0L;
    long replicated = 0L;
    long paged = 0L;
    private int errorCode = -1;
    private String errorMessage = null;
    private final Executor executor;
    private static int maxDebugTrackers = Integer.parseInt(System.getProperty("ARTEMIS_OPCONTEXT_MAX_DEBUG_TRACKERS", "0"));
    private Buffer debugTrackers = maxDebugTrackers > 0 ? BufferUtils.synchronizedBuffer((Buffer)new CircularFifoBuffer(maxDebugTrackers)) : null;

    public static void clearContext() {
        threadLocalContext.set(null);
    }

    public static final OperationContext getContext() {
        return OperationContextImpl.getContext(null);
    }

    public static OperationContext getContext(ExecutorFactory executorFactory) {
        OperationContext token = threadLocalContext.get();
        if (token == null) {
            if (executorFactory == null) {
                return null;
            }
            token = new OperationContextImpl((Executor)executorFactory.getExecutor());
            threadLocalContext.set(token);
        }
        return token;
    }

    public static void setContext(OperationContext context) {
        threadLocalContext.set(context);
    }

    public long getReplicationLineUpField() {
        return this.replicationLineUpField;
    }

    public long getReplicated() {
        return this.replicated;
    }

    public long getStoreLineUpField() {
        return this.storeLineUpField;
    }

    public long getStored() {
        return this.stored;
    }

    public long getPagedLinedUpField() {
        return this.pageLineUpField;
    }

    public long getPaged() {
        return this.paged;
    }

    protected static int getMaxDebugTrackers() {
        return maxDebugTrackers;
    }

    protected static void setMaxDebugTrackers(int maxDebugTrackers) {
        OperationContextImpl.maxDebugTrackers = maxDebugTrackers;
    }

    protected Buffer getDebugTrackers() {
        return this.debugTrackers;
    }

    public OperationContextImpl(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void pageSyncLineUp() {
        PAGE_LINEUP_UPDATER.incrementAndGet(this);
    }

    @Override
    public synchronized void pageSyncDone() {
        ++this.paged;
        this.checkTasks();
    }

    public void storeLineUp() {
        long storeLineUpValue = STORE_LINEUP_UPDATER.incrementAndGet(this);
        if (this.debugTrackers != null) {
            this.debugTrackers.add((Object)new Exception(">" + storeLineUpValue));
        }
    }

    @Override
    public void replicationLineUp() {
        REPLICATION_LINEUP_UPDATER.incrementAndGet(this);
    }

    @Override
    public synchronized void replicationDone() {
        ++this.replicated;
        this.checkTasks();
    }

    @Override
    public void executeOnCompletion(IOCallback runnable) {
        this.executeOnCompletion(runnable, OperationConsistencyLevel.FULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeOnCompletion(IOCallback completion, OperationConsistencyLevel consistencyLevel) {
        boolean executeNow = false;
        OperationContextImpl operationContextImpl = this;
        synchronized (operationContextImpl) {
            if (this.errorCode == -1) {
                long storeLined = STORE_LINEUP_UPDATER.get(this);
                long pageLined = PAGE_LINEUP_UPDATER.get(this);
                long replicationLined = REPLICATION_LINEUP_UPDATER.get(this);
                switch (consistencyLevel) {
                    case STORAGE: {
                        if (this.storeOnlyTasks == null) {
                            this.storeOnlyTasks = new LinkedList();
                        }
                        if (storeLined == this.stored) {
                            if (this.hasNoPendingExecution()) {
                                executeNow = true;
                                break;
                            }
                            this.execute(completion);
                            break;
                        }
                        this.storeOnlyTasks.add(new StoreOnlyTaskHolder(completion, storeLined));
                        break;
                    }
                    case IGNORE_REPLICATION: {
                        if (this.ignoreReplicationTasks == null) {
                            this.ignoreReplicationTasks = new LinkedList();
                        }
                        if (storeLined == this.stored && pageLined == this.paged) {
                            if (this.hasNoPendingExecution()) {
                                executeNow = true;
                                break;
                            }
                            this.execute(completion);
                            break;
                        }
                        this.ignoreReplicationTasks.add(new IgnoreReplicationTaskHolder(completion, storeLined, pageLined));
                        break;
                    }
                    case FULL: {
                        if (this.tasks == null) {
                            this.tasks = new LinkedList();
                        }
                        if (replicationLined == this.replicated && storeLined == this.stored && pageLined == this.paged) {
                            if (this.hasNoPendingExecution()) {
                                executeNow = true;
                                break;
                            }
                            this.execute(completion);
                            break;
                        }
                        this.tasks.add(new TaskHolder(completion, storeLined, replicationLined, pageLined));
                    }
                }
            }
        }
        if (this.errorCode != -1) {
            completion.onError(this.errorCode, this.errorMessage);
        } else if (executeNow) {
            completion.done();
        }
    }

    private boolean hasNoPendingExecution() {
        return EXECUTORS_PENDING_UPDATER.get(this) == 0;
    }

    public synchronized void done() {
        ++this.stored;
        if (this.debugTrackers != null) {
            this.debugTrackers.add((Object)new Exception("<" + this.stored));
        }
        this.checkTasks();
    }

    private void checkStoreTasks() {
        LinkedList<StoreOnlyTaskHolder> storeOnlyTasks = this.storeOnlyTasks;
        assert (storeOnlyTasks != null);
        int size = storeOnlyTasks.size();
        if (size == 0) {
            return;
        }
        long stored = this.stored;
        for (int i = 0; i < size; ++i) {
            StoreOnlyTaskHolder holder = storeOnlyTasks.peek();
            if (stored < holder.storeLined) {
                return;
            }
            this.execute(holder.task);
            StoreOnlyTaskHolder removed = storeOnlyTasks.poll();
            assert (removed == holder);
        }
    }

    private void checkRegularCompletion() {
        LinkedList<TaskHolder> tasks = this.tasks;
        assert (tasks != null);
        int size = this.tasks.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            TaskHolder holder = tasks.peek();
            if (this.stored < holder.storeLined || this.replicated < holder.replicationLined || this.paged < holder.pageLined) {
                return;
            }
            this.execute(holder.task);
            TaskHolder removed = tasks.poll();
            assert (removed == holder);
        }
    }

    private void checkIgnoreReplicationCompletion() {
        LinkedList<IgnoreReplicationTaskHolder> tasks = this.ignoreReplicationTasks;
        assert (tasks != null);
        int size = tasks.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            IgnoreReplicationTaskHolder holder = tasks.peek();
            if (this.stored < holder.storeLined || this.paged < holder.pageLined) {
                return;
            }
            this.execute(holder.task);
            IgnoreReplicationTaskHolder removed = tasks.poll();
            assert (removed == holder);
        }
    }

    private void checkTasks() {
        if (this.storeOnlyTasks != null && !this.storeOnlyTasks.isEmpty()) {
            this.checkStoreTasks();
        }
        if (this.tasks != null && !this.tasks.isEmpty()) {
            this.checkRegularCompletion();
        }
        if (this.ignoreReplicationTasks != null && !this.ignoreReplicationTasks.isEmpty()) {
            this.checkIgnoreReplicationCompletion();
        }
    }

    private void execute(IOCallback task) {
        EXECUTORS_PENDING_UPDATER.incrementAndGet(this);
        try {
            this.executor.execute(() -> {
                try {
                    OperationContextImpl.clearContext();
                    task.done();
                }
                finally {
                    EXECUTORS_PENDING_UPDATER.decrementAndGet(this);
                }
            });
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorExecutingAIOCallback(e);
            EXECUTORS_PENDING_UPDATER.decrementAndGet(this);
            task.onError(ActiveMQExceptionType.INTERNAL_ERROR.getCode(), "It wasn't possible to complete IO operation due to " + e.getClass() + ": " + e.getMessage());
        }
    }

    public void complete() {
    }

    public synchronized void onError(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        if (this.tasks != null) {
            int size = this.tasks.size();
            for (int i = 0; i < size; ++i) {
                TaskHolder holder = this.tasks.poll();
                holder.task.onError(errorCode, errorMessage);
            }
        }
    }

    @Override
    public void waitCompletion() throws Exception {
        this.waitCompletion(0L);
    }

    @Override
    public boolean waitCompletion(long timeout) throws InterruptedException, ActiveMQException {
        SimpleWaitIOCallback waitCallback = new SimpleWaitIOCallback();
        this.executeOnCompletion((IOCallback)waitCallback);
        this.complete();
        if (timeout == 0L) {
            waitCallback.waitCompletion();
            return true;
        }
        return waitCallback.waitCompletion(timeout);
    }

    public String toString() {
        return "OperationContextImpl@" + Integer.toHexString(System.identityHashCode(this)) + "[, storeLineUp=" + this.storeLineUpField + ", stored=" + this.stored + ", replicationLineUp=" + this.replicationLineUpField + ", replicated=" + this.replicated + ", paged=" + this.paged + ", pageLineUp=" + this.pageLineUpField + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ", executorsPending=" + this.executorsPendingField + "]";
    }

    @Override
    public synchronized void reset() {
        this.stored = 0L;
        this.storeLineUpField = 0L;
        this.replicated = 0L;
        this.replicationLineUpField = 0L;
        this.paged = 0L;
        this.pageLineUpField = 0L;
        this.errorCode = -1;
        this.errorMessage = null;
        this.executorsPendingField = 0;
        if (this.tasks != null) {
            this.tasks.clear();
        }
        if (this.storeOnlyTasks != null) {
            this.storeOnlyTasks.clear();
        }
    }

    static final class StoreOnlyTaskHolder {
        long storeLined;
        final IOCallback task;

        public String toString() {
            return "StoreOnlyTaskHolder [storeLined=" + this.storeLined + ", task=" + this.task + "]";
        }

        StoreOnlyTaskHolder(IOCallback task, long storeLined) {
            this.storeLined = storeLined;
            this.task = task;
        }
    }

    static final class IgnoreReplicationTaskHolder {
        long storeLined;
        long pageLined;
        final IOCallback task;

        public String toString() {
            return "IgnoreReplicationTaskHolder [storeLined=" + this.storeLined + ", pageLined=" + this.pageLined + ", task=" + this.task + "]";
        }

        IgnoreReplicationTaskHolder(IOCallback task, long storeLined, long pageLined) {
            this.storeLined = storeLined;
            this.pageLined = pageLined;
            this.task = task;
        }
    }

    static final class TaskHolder {
        long storeLined;
        long replicationLined;
        long pageLined;
        final IOCallback task;

        public String toString() {
            return "TaskHolder [storeLined=" + this.storeLined + ", replicationLined=" + this.replicationLined + ", pageLined=" + this.pageLined + ", task=" + this.task + "]";
        }

        TaskHolder(IOCallback task, long storeLined, long replicationLined, long pageLined) {
            this.storeLined = storeLined;
            this.replicationLined = replicationLined;
            this.pageLined = pageLined;
            this.task = task;
        }
    }
}

