/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.impl.ServerStatus;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadableProperties {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    private Properties props = new Properties();
    private Map<String, String> invertedProps;
    private Map<String, Set<String>> invertedValueProps;
    private Map<String, Pattern> regexpProps;
    private long reloadTime = -1L;
    private final PropertiesLoader.FileNameKey key;
    private final Checksum adler32 = new Adler32();
    private long checksum = 0L;

    public ReloadableProperties(PropertiesLoader.FileNameKey key) {
        this.key = key;
    }

    public synchronized Properties getProps() {
        return this.props;
    }

    public synchronized ReloadableProperties obtained() {
        if (this.reloadTime < 0L || this.key.isReload() && this.hasModificationAfter(this.reloadTime)) {
            block4: {
                this.adler32.reset();
                this.props = new Properties(){

                    @Override
                    public synchronized Object put(Object key, Object value) {
                        String sValue;
                        String sKey = key instanceof String ? (String)key : null;
                        String string = sValue = value instanceof String ? (String)value : null;
                        if (sKey != null && sValue != null) {
                            ReloadableProperties.this.adler32.update(sKey.getBytes(StandardCharsets.UTF_8));
                            ReloadableProperties.this.adler32.update(61);
                            ReloadableProperties.this.adler32.update(sValue.getBytes(StandardCharsets.UTF_8));
                            if (!ReloadableProperties.this.looksLikeRegexp(sValue)) {
                                value = ReloadableProperties.this.normaliseStringValue(sValue);
                            }
                        }
                        return super.put(key, value);
                    }
                };
                try {
                    this.load(this.key.file(), this.props);
                    this.checksum = this.adler32.getValue();
                    this.invertedProps = null;
                    this.invertedValueProps = null;
                    this.regexpProps = null;
                    if (this.key.isDebug()) {
                        logger.debug("Load of: {}", (Object)this.key);
                    }
                }
                catch (IOException e) {
                    ActiveMQServerLogger.LOGGER.failedToLoadProperty(this.key.toString(), e.getLocalizedMessage(), e);
                    if (!this.key.isDebug()) break block4;
                    logger.debug("Load of: {}, failure exception {}", (Object)this.key, (Object)e);
                }
            }
            this.reloadTime = System.currentTimeMillis();
            this.updateStatus();
        }
        return this;
    }

    protected String normaliseStringValue(String key) {
        return key;
    }

    private void updateStatus() {
        HashMap<String, String> statusAttributes = new HashMap<String, String>();
        statusAttributes.put("Alder32", String.valueOf(this.checksum));
        statusAttributes.put("reloadTime", String.valueOf(this.reloadTime));
        ServerStatus.getInstance().update("server/jaas/properties/" + this.key.file.getName(), statusAttributes);
    }

    public synchronized Map<String, String> invertedPropertiesMap() {
        if (this.invertedProps == null) {
            this.invertedProps = new HashMap<String, String>(this.props.size());
            for (Map.Entry<Object, Object> val : this.props.entrySet()) {
                String str = (String)val.getValue();
                if (this.looksLikeRegexp(str)) continue;
                this.invertedProps.put(str, (String)val.getKey());
            }
        }
        return this.invertedProps;
    }

    public synchronized Map<String, Set<String>> invertedPropertiesValuesMap() {
        if (this.invertedValueProps == null) {
            this.invertedValueProps = new HashMap<String, Set<String>>(this.props.size());
            for (Map.Entry<Object, Object> val : this.props.entrySet()) {
                String[] userList;
                for (String user : userList = ((String)val.getValue()).split(",")) {
                    Set<String> set = this.invertedValueProps.get(user);
                    if (set == null) {
                        set = new HashSet<String>();
                        this.invertedValueProps.put(user, set);
                    }
                    set.add((String)val.getKey());
                }
            }
        }
        return this.invertedValueProps;
    }

    public synchronized Map<String, Pattern> regexpPropertiesMap() {
        if (this.regexpProps == null) {
            this.regexpProps = new HashMap<String, Pattern>(this.props.size());
            for (Map.Entry<Object, Object> val : this.props.entrySet()) {
                String str = (String)val.getValue();
                if (!this.looksLikeRegexp(str)) continue;
                try {
                    Pattern p = Pattern.compile(str.substring(1, str.length() - 1));
                    this.regexpProps.put((String)val.getKey(), p);
                }
                catch (PatternSyntaxException e) {
                    logger.warn("Ignoring invalid regexp: {}", (Object)str, (Object)e);
                }
            }
        }
        return this.regexpProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File source, Properties props) throws IOException {
        LOCK.readLock().lock();
        try (FileInputStream in = new FileInputStream(source);){
            props.load(in);
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    private boolean hasModificationAfter(long reloadTime) {
        return this.key.file.lastModified() + 1000L > reloadTime;
    }

    private boolean looksLikeRegexp(String str) {
        int len = str.length();
        return len > 2 && str.charAt(0) == '/' && str.charAt(len - 1) == '/';
    }
}

