/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.buffer;

import java.io.UnsupportedEncodingException;
import org.apache.mina.core.buffer.IoBuffer;

class IoBufferHexDumper {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    IoBufferHexDumper() {
    }

    public static String getHexDumpSlice(IoBuffer buf, int offset, int length) {
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        if (length < 0 || offset < 0 || offset + length > buf.limit()) {
            throw new IndexOutOfBoundsException();
        }
        int pos = offset;
        int items = Math.min(offset + length, offset + buf.limit()) - pos;
        if (items <= 0) {
            return "";
        }
        int lim = pos + items;
        StringBuilder out = new StringBuilder(items * 3 + 6);
        while (true) {
            int byteValue = buf.get(pos++) & 0xFF;
            out.append(hexDigit[byteValue >> 4 & 0xF]);
            out.append(hexDigit[byteValue & 0xF]);
            if (pos >= lim) break;
            out.append(' ');
        }
        return out.toString();
    }

    public static final String getPrettyHexDumpSlice(IoBuffer buf, int offset, int length) {
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        if (length < 0 || offset < 0 || offset + length > buf.limit()) {
            throw new IndexOutOfBoundsException();
        }
        int len = Math.min(length, buf.limit() - offset);
        byte[] bytes = new byte[len];
        int o = offset;
        for (int i = 0; i < len; ++i) {
            bytes[i] = buf.get(o++);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Source ");
        sb.append(buf);
        sb.append(" showing index ");
        sb.append(offset);
        sb.append(" through ");
        sb.append(offset + length);
        sb.append("\n");
        sb.append(IoBufferHexDumper.toPrettyHexDump(bytes, 0, bytes.length));
        return sb.toString();
    }

    public static final String toPrettyHexDump(byte[] data, int pos, int len) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        if (len < 0 || pos < 0 || pos + len > data.length) {
            throw new IndexOutOfBoundsException();
        }
        StringBuilder b = new StringBuilder();
        int c = 0;
        int line = 16;
        for (int i = pos; i < len; i += line) {
            b.append(String.format("%06d", c) + "  ");
            b.append(IoBufferHexDumper.toPrettyHexDumpLine(data, i, Math.min(pos + len - i, line), 8, line));
            if (i + line < len) {
                b.append("\n");
            }
            c += line;
        }
        return b.toString();
    }

    private static final String toPrettyHexDumpLine(byte[] data, int pos, int len, int col, int line) {
        if (line % 2 != 0) {
            throw new IllegalArgumentException("length must be multiple of 2");
        }
        StringBuilder b = new StringBuilder();
        int i = pos;
        int t = Math.min(data.length - pos, len) + pos;
        while (i < t) {
            for (int x = 0; x < col && i < t; ++i, ++x) {
                b.append(IoBufferHexDumper.toHex(data[i]));
                b.append(" ");
            }
            b.append(" ");
        }
        int cl = line * 3 + line / col;
        if (b.length() != cl) {
            cl -= b.length();
            while (cl > 0) {
                b.append(" ");
                --cl;
            }
        }
        try {
            String p = new String(data, pos, Math.min(data.length - pos, len), "Cp1252").replace("\r\n", "..").replace("\n", ".").replace("\\", ".");
            char[] ch = p.toCharArray();
            for (int m = 0; m < ch.length; ++m) {
                if (ch[m] >= ' ') continue;
                ch[m] = 46;
            }
            b.append(ch);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return b.toString();
    }

    public static final String toHex(byte b) {
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }
}

