/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.digester3.Rule;
import org.xml.sax.Attributes;

public class SetPropertyRule
extends Rule {
    protected String name = null;
    protected String value = null;

    public SetPropertyRule(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        Object desc;
        if (attributes.getLength() == 0) {
            return;
        }
        String actualName = null;
        String actualValue = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeName = attributes.getLocalName(i);
            if ("".equals(attributeName)) {
                attributeName = attributes.getQName(i);
            }
            String value = attributes.getValue(i);
            if (attributeName.equals(this.name)) {
                actualName = value;
                continue;
            }
            if (!attributeName.equals(this.value)) continue;
            actualValue = value;
        }
        Object top = this.getDigester().peek();
        if (this.getDigester().getLogger().isDebugEnabled()) {
            this.getDigester().getLogger().debug(String.format("[SetPropertiesRule]{%s} Set %s property %s to %s", this.getDigester().getMatch(), top.getClass().getName(), actualName, actualValue));
        }
        if (top instanceof DynaBean ? (desc = ((DynaBean)top).getDynaClass().getDynaProperty(actualName)) == null : (desc = PropertyUtils.getPropertyDescriptor(top, actualName)) == null) {
            throw new NoSuchMethodException("Bean has no property named " + actualName);
        }
        BeanUtils.setProperty(top, actualName, actualValue);
    }

    public String toString() {
        return String.format("SetPropertyRule[name=%s, value=%s]", this.name, this.value);
    }
}

