/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple;

import java.util.Random;
import org.apache.commons.rng.UniformRandomProvider;

public final class JDKRandomWrapper
implements UniformRandomProvider {
    private final Random rng;

    public JDKRandomWrapper(Random rng) {
        this.rng = rng;
    }

    public void nextBytes(byte[] bytes) {
        this.rng.nextBytes(bytes);
    }

    public void nextBytes(byte[] bytes, int start, int len) {
        byte[] reduced = new byte[len];
        this.rng.nextBytes(reduced);
        System.arraycopy(reduced, 0, bytes, start, len);
    }

    public int nextInt() {
        return this.rng.nextInt();
    }

    public int nextInt(int n) {
        return this.rng.nextInt(n);
    }

    public long nextLong() {
        return this.rng.nextLong();
    }

    public long nextLong(long n) {
        long val;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("Must be strictly positive: " + n);
        }
        while ((bits = this.nextLong() >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public boolean nextBoolean() {
        return this.rng.nextBoolean();
    }

    public float nextFloat() {
        return this.rng.nextFloat();
    }

    public double nextDouble() {
        return this.rng.nextDouble();
    }
}

