/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.shape;

final class Coordinates {
    private Coordinates() {
    }

    static double[] requireFinite(double[] values, String message) {
        for (double value : values) {
            if (Double.isFinite(value)) continue;
            throw new IllegalArgumentException(message + " contains non-finite value: " + value);
        }
        return values;
    }

    static double[] requireLength(double[] values, int length, String message) {
        if (values.length != length) {
            throw new IllegalArgumentException(String.format("%s length mismatch: %d != %d", message, values.length, length));
        }
        return values;
    }
}

