/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratSampler;

public abstract class StableSampler
implements SharedStateContinuousSampler {
    private static final double PI_2 = 1.5707963267948966;
    private static final double ALPHA_GAUSSIAN = 2.0;
    private static final double ALPHA_CAUCHY = 1.0;
    private static final double ALPHA_LEVY = 0.5;
    private static final double ALPHA_SMALL = 0.02;
    private static final double BETA_LEVY = 1.0;
    private static final double GAMMA_1 = 1.0;
    private static final double DELTA_0 = 0.0;
    private static final double TAU_ZERO = 0.0;
    private static final double LOWER = Double.NEGATIVE_INFINITY;
    private static final double UPPER = Double.POSITIVE_INFINITY;
    private final UniformRandomProvider rng;

    StableSampler(UniformRandomProvider rng) {
        this.rng = rng;
    }

    @Override
    public abstract double sample();

    @Override
    public abstract StableSampler withUniformRandomProvider(UniformRandomProvider var1);

    long nextLong() {
        return this.rng.nextLong();
    }

    public String toString() {
        return "Stable deviate [" + this.rng.toString() + "]";
    }

    public static StableSampler of(UniformRandomProvider rng, double alpha, double beta) {
        StableSampler.validateParameters(alpha, beta);
        return StableSampler.create(rng, alpha, beta);
    }

    public static StableSampler of(UniformRandomProvider rng, double alpha, double beta, double gamma, double delta) {
        StableSampler.validateParameters(alpha, beta, gamma, delta);
        if (alpha == 2.0) {
            return new GaussianStableSampler(rng, gamma, delta);
        }
        if (alpha == 1.0 && CMSStableSampler.getTau(1.0, beta) == 0.0) {
            return new CauchyStableSampler(rng, gamma, delta);
        }
        if (alpha == 0.5 && Math.abs(beta) == 1.0) {
            return new LevyStableSampler(rng, beta * gamma, delta);
        }
        StableSampler sampler = StableSampler.create(rng, alpha, beta);
        return new TransformedStableSampler(sampler, gamma, delta);
    }

    private static StableSampler create(UniformRandomProvider rng, double alpha, double beta) {
        if (alpha == 2.0) {
            return new GaussianStableSampler(rng, 1.0, 0.0);
        }
        double tau = CMSStableSampler.getTau(alpha, beta);
        if (tau == 0.0) {
            if (alpha == 1.0) {
                return new CauchyStableSampler(rng, 1.0, 0.0);
            }
            if (alpha <= 0.02) {
                return new Beta0WeronStableSampler(rng, alpha);
            }
            return new Beta0CMSStableSampler(rng, alpha);
        }
        if (alpha == 1.0) {
            return new Alpha1CMSStableSampler(rng, beta);
        }
        if (alpha == 0.5 && Math.abs(beta) == 1.0) {
            return new LevyStableSampler(rng, beta, 0.0);
        }
        if (alpha <= 0.02) {
            return new WeronStableSampler(rng, alpha, beta);
        }
        return new CMSStableSampler(rng, alpha, beta);
    }

    private static void validateParameters(double alpha, double beta) {
        double eps = 1.0 - alpha;
        if (!(-1.0 <= eps) || !(eps < 1.0)) {
            throw new IllegalArgumentException("alpha is not in the interval (0, 2]: " + alpha);
        }
        if (!(-1.0 <= beta) || !(beta <= 1.0)) {
            throw new IllegalArgumentException("beta is not in the interval [-1, 1]: " + beta);
        }
    }

    private static void validateParameters(double alpha, double beta, double gamma, double delta) {
        StableSampler.validateParameters(alpha, beta);
        InternalUtils.requireStrictlyPositiveFinite(gamma, "gamma");
        InternalUtils.requireFinite(delta, "delta");
    }

    static final class SpecialMath {
        private static final double PI_4 = 0.7853981633974483;
        private static final double FOUR_PI = 1.2732395447351628;
        private static final double P0 = -5.712939549476837E9;
        private static final double P1 = 4.9468559775425065E8;
        private static final double P2 = -9429037.070546336;
        private static final double P3 = 52827.25819868892;
        private static final double P4 = -69.83913274721552;
        private static final double Q0 = -7.273940551075394E9;
        private static final double Q1 = 2.1254973418582485E9;
        private static final double Q2 = -8.000791217568675E7;
        private static final double Q3 = 823285.5955751828;
        private static final double Q4 = -2396.5768102610937;
        private static final double SWITCH_TO_EXPM1 = 0.5;

        private SpecialMath() {
        }

        static double d2(double x) {
            if (Math.abs(x) < 0.5) {
                if (x == 0.0) {
                    return 1.0;
                }
                return Math.expm1(x) / x;
            }
            if (x < Double.POSITIVE_INFINITY) {
                return (Math.exp(x) - 1.0) / x;
            }
            return x;
        }

        static double tan2(double x) {
            if (Math.abs(x) > 0.7853981633974483) {
                return Math.tan(x) / x;
            }
            double xi = x * 1.2732395447351628;
            double x2 = xi * xi;
            double x4 = x2 * x2;
            double x6 = x4 * x2;
            double x8 = x4 * x4;
            return (x8 * -69.83913274721552 + x6 * 52827.25819868892 + x4 * -9429037.070546336 + x2 * 4.9468559775425065E8 + -5.712939549476837E9) / (0.7853981633974483 * (x8 * x2 + x8 * -2396.5768102610937 + x6 * 823285.5955751828 + x4 * -8.000791217568675E7 + x2 * 2.1254973418582485E9 + -7.273940551075394E9));
        }
    }

    static class Beta0CMSStableSampler
    extends Beta0WeronStableSampler {
        Beta0CMSStableSampler(UniformRandomProvider rng, double alpha) {
            super(rng, alpha);
        }

        Beta0CMSStableSampler(UniformRandomProvider rng, Beta0CMSStableSampler source) {
            super(rng, source);
        }

        @Override
        public double sample() {
            double f;
            double b2p;
            double a2;
            double b;
            double db;
            double b2;
            double phiby2 = this.getPhiBy2();
            double w = this.getOmega();
            double a = phiby2 * SpecialMath.tan2(phiby2);
            double da = a * a;
            double a2p = 1.0 + da;
            double z = a2p * (b2 = 1.0 - (db = (b = this.eps * phiby2 * SpecialMath.tan2(this.eps * phiby2)) * b)) / (w * (a2 = 1.0 - da) * (b2p = 1.0 + db));
            double alogz = Math.log(z);
            double d = SpecialMath.d2(this.epsDiv1mEps * alogz) * (alogz * this.inv1mEps);
            double x = (1.0 + this.eps * d) * (f = 2.0 * ((a - b) * (1.0 + a * b)) / (a2 * b2p));
            if (Double.NEGATIVE_INFINITY < x && x < Double.POSITIVE_INFINITY) {
                return x;
            }
            return this.createSample(phiby2 * 2.0, w);
        }

        @Override
        public Beta0CMSStableSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new Beta0CMSStableSampler(rng, this);
        }
    }

    static class Beta0WeronStableSampler
    extends BaseStableSampler {
        protected final double eps;
        protected final double meps1;
        protected final double inv1mEps;
        protected final double epsDiv1mEps;

        Beta0WeronStableSampler(UniformRandomProvider rng, double alpha) {
            super(rng);
            this.eps = 1.0 - alpha;
            this.meps1 = 1.0 - this.eps;
            this.inv1mEps = 1.0 / this.meps1;
            this.epsDiv1mEps = this.inv1mEps - 1.0;
        }

        Beta0WeronStableSampler(UniformRandomProvider rng, Beta0WeronStableSampler source) {
            super(rng);
            this.eps = source.eps;
            this.meps1 = source.meps1;
            this.inv1mEps = source.inv1mEps;
            this.epsDiv1mEps = source.epsDiv1mEps;
        }

        @Override
        public double sample() {
            double phi = this.getPhi();
            double w = this.getOmega();
            return this.createSample(phi, w);
        }

        protected double createSample(double phi, double w) {
            double t1 = Math.sin(this.meps1 * phi) / Math.pow(Math.cos(phi), this.inv1mEps);
            if (t1 == 0.0) {
                return 0.0;
            }
            double t2 = Math.pow(Math.cos(this.eps * phi) / w, this.epsDiv1mEps);
            if (t2 == 0.0) {
                return 0.0;
            }
            return t1 * t2;
        }

        @Override
        public Beta0WeronStableSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new Beta0WeronStableSampler(rng, this);
        }
    }

    static class Alpha1CMSStableSampler
    extends BaseStableSampler {
        private final double tau;

        Alpha1CMSStableSampler(UniformRandomProvider rng, double beta) {
            super(rng);
            this.tau = beta / 1.5707963267948966;
        }

        Alpha1CMSStableSampler(UniformRandomProvider rng, Alpha1CMSStableSampler source) {
            super(rng);
            this.tau = source.tau;
        }

        @Override
        public double sample() {
            double phiby2 = this.getPhiBy2();
            double w = this.getOmega();
            double a = phiby2 * SpecialMath.tan2(phiby2);
            double da = a * a;
            double a2 = 1.0 - da;
            double a2p = 1.0 + da;
            double z = a2p * (1.0 + 2.0 * phiby2 * this.tau) / (w * a2);
            double d = Math.log(z);
            double f = 2.0 * (a - phiby2 * this.tau * (-2.0 * a)) / a2;
            return f + this.tau * d;
        }

        @Override
        public Alpha1CMSStableSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new Alpha1CMSStableSampler(rng, this);
        }
    }

    static class CMSStableSampler
    extends WeronStableSampler {
        private static final double HALF = 0.5;
        private final double tau;

        CMSStableSampler(UniformRandomProvider rng, double alpha, double beta) {
            super(rng, alpha, beta);
            this.tau = CMSStableSampler.getTau(alpha, beta);
        }

        CMSStableSampler(UniformRandomProvider rng, CMSStableSampler source) {
            super(rng, source);
            this.tau = source.tau;
        }

        static double getTau(double alpha, double beta) {
            double eps = 1.0 - alpha;
            double meps1 = 1.0 - eps;
            double tau = Math.abs(eps) < 0.5 ? beta / (SpecialMath.tan2(eps * 1.5707963267948966) * 1.5707963267948966) : (meps1 > 1.0 ? beta * 1.5707963267948966 * eps * (2.0 - meps1) * -SpecialMath.tan2((2.0 - meps1) * 1.5707963267948966) : beta * 1.5707963267948966 * eps * meps1 * SpecialMath.tan2(meps1 * 1.5707963267948966));
            return tau;
        }

        @Override
        public double sample() {
            double f;
            double b2p;
            double a2;
            double bb;
            double b;
            double db;
            double b2;
            double phiby2 = this.getPhiBy2();
            double w = this.getOmega();
            double a = phiby2 * SpecialMath.tan2(phiby2);
            double da = a * a;
            double a2p = 1.0 + da;
            double z = a2p * ((b2 = 1.0 - (db = (b = this.eps * phiby2 * (bb = SpecialMath.tan2(this.eps * phiby2))) * b)) + 2.0 * phiby2 * bb * this.tau) / (w * (a2 = 1.0 - da) * (b2p = 1.0 + db));
            double alogz = Math.log(z);
            double d = SpecialMath.d2(this.epsDiv1mEps * alogz) * (alogz * this.inv1mEps);
            double x = (1.0 + this.eps * d) * (f = 2.0 * ((a - b) * (1.0 + a * b) - phiby2 * this.tau * bb * (b * a2 - 2.0 * a)) / (a2 * b2p)) + this.tau * d;
            if (this.lower < x && x < this.upper) {
                return x;
            }
            return this.createSample(phiby2 * 2.0, w);
        }

        @Override
        public CMSStableSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new CMSStableSampler(rng, this);
        }
    }

    static class WeronStableSampler
    extends BaseStableSampler {
        protected final double eps;
        protected final double meps1;
        protected final double zeta;
        protected final double atanZeta;
        protected final double scale;
        protected final double inv1mEps;
        protected final double epsDiv1mEps;
        protected final double lower;
        protected final double upper;

        WeronStableSampler(UniformRandomProvider rng, double alpha, double beta) {
            super(rng);
            this.eps = 1.0 - alpha;
            this.meps1 = 1.0 - this.eps;
            this.zeta = this.meps1 > 1.0 ? beta * Math.tan((2.0 - this.meps1) * 1.5707963267948966) : -beta * Math.tan(this.meps1 * 1.5707963267948966);
            this.atanZeta = Math.atan(-this.zeta);
            this.scale = Math.pow(1.0 + this.zeta * this.zeta, 0.5 / this.meps1);
            this.inv1mEps = 1.0 / this.meps1;
            this.epsDiv1mEps = this.inv1mEps - 1.0;
            if (alpha < 1.0 && Math.abs(beta) == 1.0) {
                if (beta == 1.0) {
                    this.lower = this.zeta;
                    this.upper = Double.POSITIVE_INFINITY;
                } else {
                    this.lower = Double.NEGATIVE_INFINITY;
                    this.upper = this.zeta;
                }
            } else {
                this.lower = Double.NEGATIVE_INFINITY;
                this.upper = Double.POSITIVE_INFINITY;
            }
        }

        WeronStableSampler(UniformRandomProvider rng, WeronStableSampler source) {
            super(rng);
            this.eps = source.eps;
            this.meps1 = source.meps1;
            this.zeta = source.zeta;
            this.atanZeta = source.atanZeta;
            this.scale = source.scale;
            this.inv1mEps = source.inv1mEps;
            this.epsDiv1mEps = source.epsDiv1mEps;
            this.lower = source.lower;
            this.upper = source.upper;
        }

        @Override
        public double sample() {
            double phi = this.getPhi();
            double w = this.getOmega();
            return this.createSample(phi, w);
        }

        protected double createSample(double phi, double w) {
            double t1 = Math.sin(this.meps1 * phi + this.atanZeta);
            if (t1 == 0.0) {
                return this.zeta;
            }
            t1 /= Math.pow(Math.cos(phi), this.inv1mEps);
            double t2 = Math.pow(Math.cos(this.eps * phi - this.atanZeta) / w, this.epsDiv1mEps);
            if (t2 == 0.0) {
                return this.zeta;
            }
            double x = t1 * t2 * this.scale + this.zeta;
            if (x <= this.lower) {
                return this.lower;
            }
            return x < this.upper ? x : this.upper;
        }

        @Override
        public WeronStableSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new WeronStableSampler(rng, this);
        }
    }

    private static final class LevyStableSampler
    extends StableSampler {
        private final NormalizedGaussianSampler sampler;
        private final double gamma;
        private final double delta;

        LevyStableSampler(UniformRandomProvider rng, double gamma, double delta) {
            super(rng);
            this.sampler = ZigguratSampler.NormalizedGaussian.of(rng);
            this.gamma = gamma;
            this.delta = delta;
        }

        LevyStableSampler(UniformRandomProvider rng, LevyStableSampler source) {
            super(rng);
            this.sampler = ZigguratSampler.NormalizedGaussian.of(rng);
            this.gamma = source.gamma;
            this.delta = source.delta;
        }

        @Override
        public double sample() {
            double norm = this.sampler.sample();
            double z = 1.0 / (norm * norm) - 1.0;
            return this.gamma * z + this.delta;
        }

        @Override
        public LevyStableSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new LevyStableSampler(rng, this);
        }
    }

    private static final class CauchyStableSampler
    extends BaseStableSampler {
        private final double gamma;
        private final double delta;

        CauchyStableSampler(UniformRandomProvider rng, double gamma, double delta) {
            super(rng);
            this.gamma = gamma;
            this.delta = delta;
        }

        CauchyStableSampler(UniformRandomProvider rng, CauchyStableSampler source) {
            super(rng);
            this.gamma = source.gamma;
            this.delta = source.delta;
        }

        @Override
        public double sample() {
            double phiby2 = this.getPhiBy2();
            double a = phiby2 * SpecialMath.tan2(phiby2);
            double a2 = 1.0 - a * a;
            double x = 2.0 * a / a2;
            return this.gamma * x + this.delta;
        }

        @Override
        public CauchyStableSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new CauchyStableSampler(rng, this);
        }
    }

    private static final class GaussianStableSampler
    extends StableSampler {
        private static final double ROOT_2 = Math.sqrt(2.0);
        private final NormalizedGaussianSampler sampler;
        private final double stdDev;
        private final double mean;

        GaussianStableSampler(UniformRandomProvider rng, double gamma, double delta) {
            super(rng);
            this.sampler = ZigguratSampler.NormalizedGaussian.of(rng);
            this.stdDev = Math.min(Double.MAX_VALUE, ROOT_2 * gamma);
            this.mean = delta;
        }

        GaussianStableSampler(UniformRandomProvider rng, GaussianStableSampler source) {
            super(rng);
            this.sampler = ZigguratSampler.NormalizedGaussian.of(rng);
            this.stdDev = source.stdDev;
            this.mean = source.mean;
        }

        @Override
        public double sample() {
            return this.stdDev * this.sampler.sample() + this.mean;
        }

        @Override
        public GaussianStableSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new GaussianStableSampler(rng, this);
        }
    }

    private static final class TransformedStableSampler
    extends StableSampler {
        private final StableSampler sampler;
        private final double gamma;
        private final double delta;

        TransformedStableSampler(StableSampler sampler, double gamma, double delta) {
            super(null);
            this.sampler = sampler;
            this.gamma = gamma;
            this.delta = delta;
        }

        @Override
        public double sample() {
            return this.gamma * this.sampler.sample() + this.delta;
        }

        @Override
        public StableSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new TransformedStableSampler(this.sampler.withUniformRandomProvider(rng), this.gamma, this.delta);
        }

        @Override
        public String toString() {
            return this.sampler.toString();
        }
    }

    private static abstract class BaseStableSampler
    extends StableSampler {
        private static final double PI_2_SCALED = 1.743934249004316E-16;
        private static final double PI_4_SCALED = 8.71967124502158E-17;
        private static final double NEG_PI_2 = -1.5707963267948966;
        private static final double NEG_PI_4 = -0.7853981633974483;
        private final ContinuousSampler expSampler;

        BaseStableSampler(UniformRandomProvider rng) {
            super(rng);
            this.expSampler = ZigguratSampler.Exponential.of(rng);
        }

        double getOmega() {
            return this.expSampler.sample();
        }

        double getPhi() {
            double x = (double)(this.nextLong() >> 10) * 1.743934249004316E-16;
            if (x == -1.5707963267948966) {
                return this.getPhi();
            }
            return x;
        }

        double getPhiBy2() {
            double x = (double)(this.nextLong() >> 10) * 8.71967124502158E-17;
            if (x == -0.7853981633974483) {
                return this.getPhiBy2();
            }
            return x;
        }
    }
}

