/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;

public class GaussianSampler
implements SharedStateContinuousSampler {
    private final double mean;
    private final double standardDeviation;
    private final NormalizedGaussianSampler normalized;

    public GaussianSampler(NormalizedGaussianSampler normalized, double mean, double standardDeviation) {
        this(InternalUtils.requireFinite(mean, "mean"), InternalUtils.requireStrictlyPositiveFinite(standardDeviation, "standardDeviation"), normalized);
    }

    private GaussianSampler(double mean, double standardDeviation, NormalizedGaussianSampler normalized) {
        this.normalized = normalized;
        this.mean = mean;
        this.standardDeviation = standardDeviation;
    }

    @Override
    public double sample() {
        return this.standardDeviation * this.normalized.sample() + this.mean;
    }

    public String toString() {
        return "Gaussian deviate [" + this.normalized.toString() + "]";
    }

    @Override
    public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new GaussianSampler(this.mean, this.standardDeviation, InternalUtils.newNormalizedGaussianSampler(this.normalized, rng));
    }

    public static SharedStateContinuousSampler of(NormalizedGaussianSampler normalized, double mean, double standardDeviation) {
        return new GaussianSampler(normalized, mean, standardDeviation);
    }
}

