/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;

public class CodeValidationUtil {
    private static String validationMessage(String attribute, String message) {
        StringBuffer buffer = new StringBuffer(message.length() + attribute.length() + 5);
        buffer.append('\"').append(attribute).append("\" ").append(message);
        return buffer.toString();
    }

    public static ValidationFailure validateJavaIdentifier(Object bean, String attribute, String identifier) {
        ValidationFailure emptyFailure = BeanValidationFailure.validateNotEmpty(bean, attribute, identifier);
        if (emptyFailure != null) {
            return emptyFailure;
        }
        char c = identifier.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return new BeanValidationFailure(bean, attribute, CodeValidationUtil.validationMessage(attribute, " starts with invalid character: " + c));
        }
        for (int i = 1; i < identifier.length(); ++i) {
            c = identifier.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            return new BeanValidationFailure(bean, attribute, CodeValidationUtil.validationMessage(attribute, " contains invalid character: " + c));
        }
        return null;
    }
}

