/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.cgen;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.modeler.dialog.cgen.TemplateDialogView;
import org.apache.cayenne.modeler.editor.cgen.CustomModeController;
import org.apache.cayenne.modeler.util.CayenneController;

public class TemplateDialog
extends CayenneController {
    protected TemplateDialogView view;
    private CgenConfiguration cgenConfiguration;
    private String template;
    private String superTemplate;

    public TemplateDialog(CayenneController parent, CgenConfiguration cgenConfiguration, String template, String superTemplate) {
        super(parent);
        this.cgenConfiguration = cgenConfiguration;
        this.template = template;
        this.superTemplate = superTemplate;
        Window parentView = parent.getView() instanceof Window ? (Window)parent.getView() : SwingUtilities.getWindowAncestor(parent.getView());
        this.view = parentView instanceof Dialog ? new TemplateDialogView((Dialog)parentView, template, superTemplate) : new TemplateDialogView((Frame)parentView, template, superTemplate);
        this.initListeners();
    }

    public void startupAction() {
        this.view.pack();
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.view.setVisible(true);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    private void initListeners() {
        this.view.getUseDefault().addActionListener(action -> {
            if (this.template != null) {
                this.cgenConfiguration.setTemplate("templates/v4_1/subclass.vm");
            }
            if (this.superTemplate != null) {
                this.cgenConfiguration.setSuperTemplate("templates/v4_1/superclass.vm");
            }
            this.view.dispose();
        });
        this.view.getAddTemplate().addActionListener(action -> {
            ((CustomModeController)this.parent).addTemplateAction(this.template, this.superTemplate);
            this.view.dispose();
        });
    }
}

