/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlserver;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.oracle.OraclePkGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbKeyGenerator;
import org.apache.cayenne.map.Entity;

public class SQLServerPkGenerator
extends OraclePkGenerator {
    private static final String SELECT_NEW_GUID = "SELECT NEWID()";
    private static final String SEQUENCE_PREFIX = "_pk";
    private static final int MAX_LENGTH_GUID = 36;

    public SQLServerPkGenerator() {
    }

    protected SQLServerPkGenerator(JdbcAdapter adapter) {
        super(adapter);
    }

    @Override
    protected String createSequenceString(DbEntity ent) {
        return "CREATE SEQUENCE " + this.sequenceName(ent) + " AS [bigint] START WITH " + this.pkStartValue + " INCREMENT BY " + this.pkCacheSize(ent) + " NO CACHE";
    }

    @Override
    protected String getSequencePrefix() {
        return SEQUENCE_PREFIX;
    }

    @Override
    protected String selectNextValQuery(String sequenceName) {
        return "SELECT NEXT VALUE FOR " + sequenceName;
    }

    @Override
    public List<String> createAutoPkStatements(List<DbEntity> dbEntities) {
        ArrayList<String> list = new ArrayList<String>(dbEntities.size());
        for (DbEntity dbEntity : dbEntities) {
            DbAttribute pk;
            if (dbEntity.getPrimaryKeys().size() != 1 || !TypesMapping.isNumeric((pk = dbEntity.getPrimaryKeys().iterator().next()).getType())) continue;
            list.add(this.createSequenceString(dbEntity));
        }
        return list;
    }

    @Override
    public List<String> dropAutoPkStatements(List<DbEntity> dbEntities) {
        ArrayList<String> list = new ArrayList<String>(dbEntities.size());
        for (DbEntity dbEntity : dbEntities) {
            DbAttribute pk;
            if (dbEntity.getPrimaryKeys().size() != 1 || !TypesMapping.isNumeric((pk = dbEntity.getPrimaryKeys().iterator().next()).getType())) continue;
            list.add(this.dropSequenceString(dbEntity));
        }
        return list;
    }

    @Override
    public Object generatePk(DataNode node, DbAttribute pk) throws Exception {
        DbEntity entity = pk.getEntity();
        if (TypesMapping.isCharacter(pk.getType()) && pk.getMaxLength() == 36) {
            return this.guidPkFromDatabase(node, entity);
        }
        return super.generatePk(node, pk);
    }

    @Override
    protected String selectAllSequencesQuery() {
        return "SELECT seq.name FROM sys.sequences AS seq JOIN sys.schemas AS sch ON seq.schema_id = sch.schema_id";
    }

    @Override
    protected String sequenceName(DbEntity entity) {
        DbKeyGenerator keyGenerator = entity.getPrimaryKeyGenerator();
        if (keyGenerator != null && "ORACLE".equals(keyGenerator.getGeneratorType()) && keyGenerator.getGeneratorName() != null) {
            return keyGenerator.getGeneratorName().toLowerCase();
        }
        String seqName = entity.getName().toLowerCase() + this.getSequencePrefix();
        return this.adapter.getQuotingStrategy().quotedIdentifier((Entity)entity, entity.getSchema(), seqName);
    }

    /*
     * Exception decompiling
     */
    protected String guidPkFromDatabase(DataNode node, DbEntity entity) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

