/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc.reader;

import java.sql.ResultSet;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.reader.DataRowPostProcessor;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.QueryMetadata;

abstract class BaseRowReader<T>
implements RowReader<T> {
    ExtendedType[] converters;
    String[] labels;
    int[] types;
    DataRowPostProcessor postProcessor;
    String entityName;

    BaseRowReader(RowDescriptor descriptor, QueryMetadata queryMetadata, DataRowPostProcessor postProcessor) {
        ObjEntity rootObjEntity = queryMetadata.getObjEntity();
        if (rootObjEntity != null) {
            this.entityName = rootObjEntity.getName();
        }
        this.postProcessor = postProcessor;
        this.converters = descriptor.getConverters();
        ColumnDescriptor[] columns = descriptor.getColumns();
        int width = columns.length;
        this.labels = new String[width];
        this.types = new int[width];
        for (int i = 0; i < width; ++i) {
            this.labels[i] = columns[i].getDataRowKey();
            this.types[i] = columns[i].getJdbcType();
        }
    }

    @Override
    public abstract T readRow(ResultSet var1);
}

