/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationstatus.conditions.pods;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.time.ZonedDateTime;
import org.apache.camel.v1.integrationstatus.conditions.pods.ConditionBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"lastProbeTime", "lastTransitionTime", "message", "reason", "status", "type"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Condition
implements Editable<ConditionBuilder>,
KubernetesResource {
    @JsonProperty(value="lastProbeTime")
    @JsonPropertyDescription(value="Last time we probed the condition.")
    @JsonSetter(nulls=Nulls.SKIP)
    private ZonedDateTime lastProbeTime;
    @JsonProperty(value="lastTransitionTime")
    @JsonPropertyDescription(value="Last time the condition transitioned from one status to another.")
    @JsonSetter(nulls=Nulls.SKIP)
    private ZonedDateTime lastTransitionTime;
    @JsonProperty(value="message")
    @JsonPropertyDescription(value="Human-readable message indicating details about last transition.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String message;
    @JsonProperty(value="reason")
    @JsonPropertyDescription(value="Unique, one-word, CamelCase reason for the condition's last transition.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String reason;
    @JsonProperty(value="status")
    @Required
    @JsonPropertyDescription(value="Status is the status of the condition. Can be True, False, Unknown. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions")
    @JsonSetter(nulls=Nulls.SKIP)
    private String status;
    @JsonProperty(value="type")
    @Required
    @JsonPropertyDescription(value="Type is the type of the condition. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions")
    @JsonSetter(nulls=Nulls.SKIP)
    private String type;

    public ConditionBuilder edit() {
        return new ConditionBuilder(this);
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssVV")
    public ZonedDateTime getLastProbeTime() {
        return this.lastProbeTime;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[XXX][VV]")
    public void setLastProbeTime(ZonedDateTime lastProbeTime) {
        this.lastProbeTime = lastProbeTime;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssVV")
    public ZonedDateTime getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[XXX][VV]")
    public void setLastTransitionTime(ZonedDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "Condition(lastProbeTime=" + this.getLastProbeTime() + ", lastTransitionTime=" + this.getLastTransitionTime() + ", message=" + this.getMessage() + ", reason=" + this.getReason() + ", status=" + this.getStatus() + ", type=" + this.getType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ZonedDateTime this$lastProbeTime = this.getLastProbeTime();
        ZonedDateTime other$lastProbeTime = other.getLastProbeTime();
        if (this$lastProbeTime == null ? other$lastProbeTime != null : !((Object)this$lastProbeTime).equals(other$lastProbeTime)) {
            return false;
        }
        ZonedDateTime this$lastTransitionTime = this.getLastTransitionTime();
        ZonedDateTime other$lastTransitionTime = other.getLastTransitionTime();
        if (this$lastTransitionTime == null ? other$lastTransitionTime != null : !((Object)this$lastTransitionTime).equals(other$lastTransitionTime)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Condition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ZonedDateTime $lastProbeTime = this.getLastProbeTime();
        result = result * 59 + ($lastProbeTime == null ? 43 : ((Object)$lastProbeTime).hashCode());
        ZonedDateTime $lastTransitionTime = this.getLastTransitionTime();
        result = result * 59 + ($lastTransitionTime == null ? 43 : ((Object)$lastTransitionTime).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

