/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.perf.test.generic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.perf.test.BasicState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

public class GenericStringTest {
    private static final String GENERIC_STRINGS = "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"string\" },\n{ \"name\": \"f2\", \"type\": \"string\" },\n{ \"name\": \"f3\", \"type\": \"string\" }\n] }";

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void encode(TestStateEncode state) throws Exception {
        Encoder e = state.encoder;
        GenericDatumWriter<GenericRecord> writer = new GenericDatumWriter<GenericRecord>(state.readerSchema);
        for (GenericRecord rec : state.testData) {
            writer.write(rec, e);
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void decode(Blackhole blackhole, TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        GenericDatumReader<Object> reader = new GenericDatumReader<Object>(state.readerSchema);
        for (int i = 0; i < state.getBatchSize(); ++i) {
            blackhole.consume(reader.read(null, d));
        }
    }

    private static String randomString(Random r) {
        char[] data = new char[r.nextInt(70)];
        for (int j = 0; j < data.length; ++j) {
            data[j] = (char)(97 + r.nextInt(25));
        }
        return new String(data);
    }

    @State(value=Scope.Thread)
    public static class TestStateEncode
    extends BasicState {
        private final Schema readerSchema = new Schema.Parser().parse("{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"string\" },\n{ \"name\": \"f2\", \"type\": \"string\" },\n{ \"name\": \"f3\", \"type\": \"string\" }\n] }");
        private GenericRecord[] testData;
        private Encoder encoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws Exception {
            this.encoder = super.newEncoder(false, this.getNullOutputStream());
            this.testData = new GenericRecord[this.getBatchSize()];
            for (int i = 0; i < this.testData.length; ++i) {
                GenericData.Record rec = new GenericData.Record(this.readerSchema);
                rec.put(0, (Object)GenericStringTest.randomString(super.getRandom()));
                rec.put(1, (Object)GenericStringTest.randomString(super.getRandom()));
                rec.put(2, (Object)GenericStringTest.randomString(super.getRandom()));
                this.testData[i] = rec;
            }
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicState {
        private final Schema readerSchema = new Schema.Parser().parse("{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"string\" },\n{ \"name\": \"f2\", \"type\": \"string\" },\n{ \"name\": \"f3\", \"type\": \"string\" }\n] }");
        private byte[] testData;
        private Decoder decoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            for (int i = 0; i < this.getBatchSize(); ++i) {
                encoder.writeString(GenericStringTest.randomString(super.getRandom()));
                encoder.writeString(GenericStringTest.randomString(super.getRandom()));
                encoder.writeString(GenericStringTest.randomString(super.getRandom()));
            }
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = DecoderFactory.get().validatingDecoder(this.readerSchema, super.newDecoder(this.testData));
        }
    }
}

