/******************************************************************************
 * (c) Copyright 2002,2004, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: SOAPServerConfig.java,v $
 * Version:       $Name:  $ $Revision: 1.10 $
 * Last Modified: $Date: 2006/07/04 11:03:22 $
 *****************************************************************************/

package org.ten60.netkernel.ws.soap.server;

import java.util.*;
import java.util.regex.*;

/**
 * SOAP Server Configuration
 * @author  pjr
 */
public class SOAPServerConfig
{
	private ArrayList mPorts;
	private Map mServices;
	private Map mWSDL;
	private String mBase;
	private final Pattern mPattern=Pattern.compile("(http://.*?/|/)(.*)");
	
	public SOAPServerConfig()
	{	mPorts=new ArrayList(4);
		mServices=new HashMap(2);
		mWSDL=new HashMap(2);
	}
	
	public void addService(String endpoint, String name) throws Exception
	{   String path=getPath(endpoint);
		if(mServices.get(path)==null)
	    {    mServices.put(path,name);	    
	    }
	    else throw new Exception("service endpoint already registered");
	}
	
	public String getServiceName(String endpoint)
	{   return (String)mServices.get(getPath(endpoint));
	}
	
	public void addPort(SOAPServicePort aPort)
	{	mPorts.add(aPort);
	}
	
	/** Find the port config for a given SOAP endpoint and action
	 **/
	public SOAPServicePort getPort(String aEndpoint, String aAction)
	{	String path=getPath(aEndpoint);
		SOAPServicePort port=null;
		Iterator i=mPorts.iterator();
		while(i.hasNext())
		{	SOAPServicePort p=(SOAPServicePort)i.next();
			String path2=getPath(p.getEndpoint());
			if(path2.equals(path) && p.getAction().equals(aAction))
			{ port=p;
			  break;
			}
		}
		return port;
	}
	
	/*
	 * For a given endpoint return a List containng all SOAPServiceConfigurations (aka Ports)
	 * which share that endpoint.
	 */
	public List getServicePorts(String aEndpoint)
	{   String path1=getPath(aEndpoint);
		ArrayList list=new ArrayList();
	    Iterator i=mPorts.iterator();
	    while(i.hasNext())
	    {	SOAPServicePort s=(SOAPServicePort)i.next();
		if(getPath(s.getEndpoint()).equals(path1)) list.add(s);
	    }
	    return list;
	}
	
	public void setWSDL(String aEndpoint, String aWSDL)
	{	mWSDL.put(getPath(aEndpoint),aWSDL);
	}
	
	public String getWSDL(String aEndpoint)
	{   return (String)mWSDL.get(getPath(aEndpoint));
	}
	
	public boolean hasWSDL(String aEndpoint)
	{   return mWSDL.get(getPath(aEndpoint))!=null;
	}
	
	public String getBaseURI()
	{	return mBase;		
	}
	
	public void setBaseURI(String aBase)
	{	mBase=aBase;
	}
	
	private String getPath(String aEndpoint)
	{	Matcher m=mPattern.matcher(aEndpoint);
		m.matches();
		return m.group(2);
	}
}