<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
    <xsl:param name="param"/>
    <xsl:template match="/">
	<html>
	    <xsl:variable name="doc" select="//port[endpoint=$param]/doc/text()"/>
	    <body>
	    <h1>Endpoint: <xsl:value-of select="$param"/></h1>
	    <a href="{$param}?WSDL">WSDL</a>
	    <xsl:choose>
		<xsl:when test="//port[contains($param, endpoint)]">
		    <h3>Registered Ports</h3>
		    <table cellspacing="0" cellpadding="2">
			<tr bgcolor="#ccccff">
			    <td>name</td>
			    <td>action</td>
			    <td/>
			</tr>
			<xsl:for-each select="//port[contains($param, endpoint)]">
			    <tr>
				<xsl:if test="position() mod 2">
				<xsl:attribute name="bgcolor">#eeeeff</xsl:attribute>
				</xsl:if>
				<td><b><xsl:value-of select="name"/></b></td>
				<td><xsl:value-of select="action"/></td>
				<td>
				    <xsl:if test="doc">
					<a><xsl:attribute name="href"><xsl:value-of select="concat($param,'?DOC+action@', action)"/></xsl:attribute>documentation</a>
				    </xsl:if>
				</td>
			    </tr>
			</xsl:for-each>
		    </table>
		</xsl:when>
		<xsl:otherwise>
		    <p>No ports registered for this endpoint</p>
		</xsl:otherwise>
	    </xsl:choose>
	    <p>Powered by <a href="http://www.1060research.com">1060 NetKernel</a></p>
	    </body>
	</html>
    </xsl:template>
</xsl:stylesheet>
