/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.EventCollection;
import org.openjdk.jmc.flightrecorder.internal.EventArrays;
import org.openjdk.jmc.flightrecorder.internal.FlightRecordingLoader;
import org.openjdk.jmc.flightrecorder.parser.IParserExtension;
import org.openjdk.jmc.flightrecorder.parser.ParserExtensionRegistry;

public class JfrLoaderToolkit {
    private static EventArrays loadFile(List<File> files, List<? extends IParserExtension> extensions) throws IOException, CouldNotLoadRecordingException {
        ArrayList<InputStream> streams = new ArrayList<InputStream>(files.size());
        for (File file : files) {
            streams.add(IOToolkit.openUncompressedStream((File)file));
        }
        try (SequenceInputStream stream = new SequenceInputStream(Collections.enumeration(streams));){
            EventArrays eventArrays = FlightRecordingLoader.loadStream(stream, extensions, false, true);
            return eventArrays;
        }
    }

    public static IItemCollection loadEvents(InputStream stream) throws IOException, CouldNotLoadRecordingException {
        return JfrLoaderToolkit.loadEvents(stream, ParserExtensionRegistry.getParserExtensions());
    }

    public static IItemCollection loadEvents(InputStream stream, List<? extends IParserExtension> extensions) throws CouldNotLoadRecordingException, IOException {
        try (InputStream in = IOToolkit.openUncompressedStream((InputStream)stream);){
            IItemCollection iItemCollection = EventCollection.build(FlightRecordingLoader.loadStream(in, extensions, false, true));
            return iItemCollection;
        }
    }

    public static IItemCollection loadEvents(File file) throws IOException, CouldNotLoadRecordingException {
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        return JfrLoaderToolkit.loadEvents(files);
    }

    public static IItemCollection loadEvents(List<File> files) throws IOException, CouldNotLoadRecordingException {
        return JfrLoaderToolkit.loadEvents(files, ParserExtensionRegistry.getParserExtensions());
    }

    public static IItemCollection loadEvents(List<File> files, List<? extends IParserExtension> extensions) throws IOException, CouldNotLoadRecordingException {
        return EventCollection.build(JfrLoaderToolkit.loadFile(files, extensions));
    }
}

