/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.EventQueue;
import java.awt.Window;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.form.BindingDesignSupport;
import org.netbeans.modules.form.BindingDesignSupportProvider;
import org.netbeans.modules.form.CodeGenerator;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.DefaultRADAction;
import org.netbeans.modules.form.EditorSupport;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormOthersNode;
import org.netbeans.modules.form.FormRootNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.GandalfPersistenceManager;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.PersistenceException;
import org.netbeans.modules.form.PersistenceManager;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.ResourceSupport;
import org.netbeans.modules.form.actions.CustomizeEmptySpaceAction;
import org.netbeans.modules.form.actions.EditContainerAction;
import org.netbeans.modules.form.actions.EditFormAction;
import org.netbeans.modules.form.assistant.AssistantModel;
import org.netbeans.modules.form.layoutdesign.LayoutDesigner;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.WeakSet;
import org.openide.util.actions.SystemAction;

public class FormEditor {
    private FormModel formModel;
    private FormRootNode formRootNode;
    private FormDesigner formDesigner;
    private EditorSupport editorSupport;
    private CodeGenerator codeGenerator;
    private FormJavaSource formJavaSource;
    private ResourceSupport resourceSupport;
    private boolean bindingSupportInitialized;
    private BindingDesignSupport bindingSupport;
    private List<Throwable> persistenceErrors;
    private PersistenceManager persistenceManager;
    private String prefetchedSuperclassName;
    private boolean formLoaded = false;
    private static Map<FormModel, FormEditor> openForms = new Hashtable<FormModel, FormEditor>();
    private static Map<FormModel, AssistantModel> formModelToAssistant = new WeakHashMap<FormModel, AssistantModel>();
    private List<Window> floatingWindows;
    private Set<FormNode> nodesWithPropertiesWindows;
    private FormDataObject formDataObject;
    private PropertyChangeListener dataObjectListener;
    private static PreferenceChangeListener settingsListener;
    private PropertyChangeListener paletteListener;
    private FormModelListener formListener;
    private List<Action> defaultActions;
    private boolean upgradeCheckPosted;

    public FormEditor(FormDataObject formDataObject, EditorSupport sourceEditor) {
        this.formDataObject = formDataObject;
        this.editorSupport = sourceEditor;
    }

    public final FormNode getFormRootNode() {
        return this.formRootNode;
    }

    public final FormNode getOthersContainerNode() {
        FormOthersNode othersNode = this.formRootNode.getOthersNode();
        return othersNode != null ? othersNode : this.formRootNode;
    }

    public final FormModel getFormModel() {
        return this.formModel;
    }

    public final FormDataObject getFormDataObject() {
        return this.formDataObject;
    }

    public final EditorSupport getEditorSupport() {
        return this.editorSupport;
    }

    Document getSourcesDocument() {
        return this.getEditorSupport().getDocument();
    }

    GuardedSectionManager getGuardedSectionManager() {
        return this.getEditorSupport().getGuardedSectionManager();
    }

    SimpleSection getVariablesSection() {
        return this.getGuardedSectionManager().findSimpleSection("variables");
    }

    SimpleSection getInitComponentSection() {
        return this.getGuardedSectionManager().findSimpleSection("initComponents");
    }

    FormJavaSource getFormJavaSource() {
        return this.getFormJavaSource(false);
    }

    private FormJavaSource getFormJavaSource(boolean create) {
        if (this.formJavaSource == null && create) {
            this.formJavaSource = new FormJavaSource((DataObject)this.formDataObject, this.editorSupport.getJavaContext());
        }
        return this.formJavaSource;
    }

    CodeGenerator getCodeGenerator() {
        if (!this.formLoaded) {
            return null;
        }
        if (this.codeGenerator == null) {
            this.codeGenerator = new JavaCodeGenerator();
        }
        return this.codeGenerator;
    }

    public void regenerateCodeIfNeeded() {
        JavaCodeGenerator codeGen = (JavaCodeGenerator)this.getCodeGenerator();
        if (codeGen != null) {
            codeGen.regenerateCode();
        }
    }

    ResourceSupport getResourceSupport() {
        if (this.resourceSupport == null && this.formModel != null) {
            this.resourceSupport = new ResourceSupport(this.formModel);
            this.resourceSupport.init();
        }
        return this.resourceSupport;
    }

    BindingDesignSupport getBindingSupport() {
        if (!this.bindingSupportInitialized && this.formModel != null) {
            BindingDesignSupportProvider provider = (BindingDesignSupportProvider)Lookup.getDefault().lookup(BindingDesignSupportProvider.class);
            if (provider != null) {
                this.bindingSupport = provider.create(this.formModel);
            }
            this.bindingSupportInitialized = true;
        }
        return this.bindingSupport;
    }

    public boolean isFormLoaded() {
        return this.formLoaded;
    }

    public boolean loadForm() {
        if (!this.formLoaded) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    FormEditor.this.loadFormData();
                }
            };
            if (EventQueue.isDispatchThread()) {
                r.run();
            } else {
                try {
                    EventQueue.invokeAndWait(r);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return this.formLoaded;
    }

    public boolean prepareLoading() {
        this.resetPersistenceErrorLog();
        if (this.persistenceManager == null) {
            try {
                this.persistenceManager = this.recognizeForm(this.formDataObject);
            }
            catch (PersistenceException ex) {
                this.logPersistenceError(ex, 0);
                return false;
            }
        }
        this.getFormJavaSource(true);
        this.prefetchedSuperclassName = null;
        return true;
    }

    public void loadOnBackground() {
        FormJavaSource javaSource = this.getFormJavaSource();
        if (javaSource != null) {
            this.prefetchedSuperclassName = javaSource.getSuperClassName();
        }
    }

    public boolean loadFormData() {
        FileObject projectDirectory;
        FileObject nbprojectFolder;
        assert (!this.formLoaded);
        Beans.setDesignTime(true);
        if (this.persistenceManager == null && !this.prepareLoading()) {
            return false;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)this.formDataObject.getFormFile());
        if (p != null && (nbprojectFolder = (projectDirectory = p.getProjectDirectory()).getFileObject("nbproject", null)) == null && projectDirectory.getFileObject("pom", "xml") != null) {
            ClassPathUtils.resetFormClassLoader(p);
        }
        if (this.persistenceManager instanceof GandalfPersistenceManager) {
            ((GandalfPersistenceManager)this.persistenceManager).setPrefetchedSuperclassName(this.prefetchedSuperclassName);
            this.prefetchedSuperclassName = null;
        }
        this.formModel = new FormModel();
        this.formModel.setName(this.formDataObject.getName());
        this.formModel.setReadOnly(this.formDataObject.isReadOnly());
        this.formModel.getCodeStructure().setFormJavaSource(this.getFormJavaSource(true));
        openForms.put(this.formModel, this);
        Logger.getLogger("TIMER").log(Level.FINE, "FormModel", new Object[]{this.formDataObject.getPrimaryFile(), this.formModel});
        this.formModel.getSettings().getAutoSetComponentName();
        try {
            FormLAF.executeWithLookAndFeel(this.formModel, new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    FormEditor.this.persistenceManager.loadForm(FormEditor.this.formDataObject, FormEditor.this.formModel, FormEditor.this.persistenceErrors);
                    return null;
                }
            });
        }
        catch (PersistenceException ex) {
            openForms.remove(this.formModel);
            this.closeForm();
            this.logPersistenceError(ex, 0);
            return false;
        }
        catch (Exception ex) {
            Logger.getLogger(FormEditor.class.getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
            openForms.remove(this.formModel);
            this.closeForm();
            return false;
        }
        this.formLoaded = true;
        this.getCodeGenerator().initialize(this.formModel);
        ResourceSupport resupport = this.getResourceSupport();
        if (resupport.getDesignLocale() != null && !"".equals(resupport.getDesignLocale())) {
            resupport.updateDesignLocale();
        }
        this.getBindingSupport();
        this.formModel.fireFormLoaded();
        if (this.formModel.wasCorrected()) {
            this.formModel.fireFormChanged(false);
        }
        this.formRootNode = new FormRootNode(this.formModel);
        this.formRootNode.getChildren().getNodes();
        this.attachFormListener();
        this.attachDataObjectListener();
        FormEditor.attachSettingsListener();
        this.attachPaletteListener();
        return true;
    }

    public boolean saveForm() {
        try {
            this.saveFormData();
            return true;
        }
        catch (PersistenceException ex) {
            this.logPersistenceError(ex, 0);
            return false;
        }
    }

    public void saveFormData() throws PersistenceException {
        if (this.formLoaded && !this.formDataObject.formFileReadOnly() && !this.formModel.isReadOnly()) {
            this.formModel.fireFormToBeSaved();
            this.resetPersistenceErrorLog();
            this.persistenceManager.saveForm(this.formDataObject, this.formModel, this.persistenceErrors);
        }
    }

    private void resetPersistenceErrorLog() {
        if (this.persistenceErrors != null) {
            this.persistenceErrors.clear();
        } else {
            this.persistenceErrors = new ArrayList<Throwable>();
        }
    }

    void logPersistenceError(Throwable t, int index) {
        if (this.persistenceErrors == null) {
            this.persistenceErrors = new ArrayList<Throwable>();
        }
        if (index < 0) {
            this.persistenceErrors.add(t);
        } else {
            this.persistenceErrors.add(index, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceManager recognizeForm(FormDataObject formDO) throws PersistenceException {
        PersistenceException ex;
        Iterator<PersistenceManager> it = PersistenceManager.getManagers();
        if (!it.hasNext()) {
            PersistenceException ex2 = new PersistenceException(FormUtils.getBundleString("MSG_ERR_NoPersistenceManager"));
            throw ex2;
        }
        do {
            PersistenceManager pm;
            PersistenceManager persistenceManager = pm = it.next();
            synchronized (persistenceManager) {
                try {
                    if (pm.canLoadForm(formDO)) {
                        this.resetPersistenceErrorLog();
                        return pm;
                    }
                }
                catch (PersistenceException ex3) {
                    this.logPersistenceError(ex3);
                }
            }
        } while (it.hasNext());
        if (!this.anyPersistenceError()) {
            ex = new PersistenceException(FormUtils.getBundleString("MSG_ERR_NotRecognizedForm"));
        } else {
            Throwable annotateT = null;
            int n = this.persistenceErrors.size();
            if (n == 1) {
                ex = (PersistenceException)this.persistenceErrors.get(0);
                Throwable t = ex.getOriginalException();
                annotateT = t != null ? t : ex;
                n = 0;
            } else {
                annotateT = ex = new PersistenceException("Form file cannot be loaded");
            }
            ErrorManager.getDefault().annotate(annotateT, FormUtils.getBundleString("MSG_ERR_LoadingErrors"));
            for (int i = 0; i < n; ++i) {
                PersistenceException pe = (PersistenceException)this.persistenceErrors.get(i);
                Throwable t = pe.getOriginalException();
                ErrorManager.getDefault().annotate((Throwable)ex, t != null ? t : pe);
            }
            this.resetPersistenceErrorLog();
        }
        throw ex;
    }

    private void logPersistenceError(Throwable t) {
        this.logPersistenceError(t, -1);
    }

    public boolean anyPersistenceError() {
        return this.persistenceErrors != null && !this.persistenceErrors.isEmpty();
    }

    public void reportSavingErrors() {
        this.reportErrors(false, null);
    }

    public String reportLoadingErrors() {
        DialogDescriptor dd = this.reportLoadingErrors(null);
        Object message = dd != null ? dd.getMessage() : null;
        return message instanceof String ? (String)message : null;
    }

    public DialogDescriptor reportLoadingErrors(Object[] options) {
        return this.reportErrors(this.formLoaded, options);
    }

    private DialogDescriptor reportErrors(boolean checkNonFatalLoadingErrors, Object[] options) {
        if (!this.anyPersistenceError()) {
            return null;
        }
        ErrorManager errorManager = ErrorManager.getDefault();
        GandalfPersistenceManager persistManager = (GandalfPersistenceManager)this.persistenceManager;
        boolean dataLossError = false;
        StringBuilder userErrorMsgs = new StringBuilder();
        for (Throwable t : this.persistenceErrors) {
            Throwable th;
            String originalMessage = null;
            if (t instanceof PersistenceException && (th = ((PersistenceException)t).getOriginalException()) != null) {
                Logger.getLogger("").log(Level.INFO, null, th);
                if (checkNonFatalLoadingErrors) {
                    t = th;
                } else {
                    originalMessage = th.getLocalizedMessage();
                }
            }
            if (checkNonFatalLoadingErrors && !dataLossError) {
                ErrorManager.Annotation[] annotations = errorManager.findAnnotations(t);
                int severity = 0;
                if (annotations != null && annotations.length != 0) {
                    for (int i = 0; i < annotations.length; ++i) {
                        int s = annotations[i].getSeverity();
                        if (s == 0) {
                            s = 4096;
                        }
                        if (s <= severity) continue;
                        severity = s;
                    }
                } else {
                    severity = 4096;
                }
                if (severity > 16) {
                    dataLossError = true;
                }
            }
            if (dataLossError && !(t instanceof PersistenceException)) {
                Logger.getLogger("").log(Level.INFO, t.getLocalizedMessage(), t);
            }
            if (checkNonFatalLoadingErrors && persistManager != null) {
                userErrorMsgs.append(persistManager.getExceptionAnnotation(t));
                userErrorMsgs.append("\n\n");
                continue;
            }
            String message = t.getLocalizedMessage();
            if (originalMessage != null && originalMessage.length() > 0) {
                message = message != null && message.length() > 0 ? message + "\n\n" + originalMessage : originalMessage;
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
        }
        DialogDescriptor dd = null;
        if (checkNonFatalLoadingErrors && dataLossError) {
            userErrorMsgs.append(FormUtils.getBundleString("MSG_FormLoadedWithErrors"));
            dd = FormUtils.createErrorDialogWithExceptions(FormUtils.getBundleString("CTL_FormLoadedWithErrors"), userErrorMsgs.toString(), 2, options, this.persistenceErrors.toArray(new Throwable[0]));
        }
        this.resetPersistenceErrorLog();
        return dd;
    }

    public void destroyInvalidComponents() {
        Collection<RADComponent> allComps = this.formModel.getAllComponents();
        ArrayList<RADComponent> invalidComponents = new ArrayList<RADComponent>(allComps.size());
        for (RADComponent comp : allComps) {
            if (comp.isValid()) continue;
            invalidComponents.add(comp);
        }
        for (RADComponent comp : invalidComponents) {
            try {
                RADComponentNode node = comp.getNodeReference();
                if (node == null) continue;
                node.destroy();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setFormReadOnly() {
        HandleLayer handleLayer;
        this.formModel.setReadOnly(true);
        FormDesigner designer = this.getFormDesigner();
        if (designer != null && (handleLayer = designer.getHandleLayer()) != null) {
            handleLayer.setViewOnly(true);
        }
        this.detachFormListener();
    }

    boolean needPostCreationUpdate() {
        return Boolean.TRUE.equals(this.formDataObject.getPrimaryFile().getAttribute("justCreatedByNewWizard"));
    }

    public boolean postCreationUpdate() {
        if (this.formLoaded && this.formModel != null && !this.formModel.isReadOnly() && !this.anyPersistenceError() && this.needPostCreationUpdate()) {
            this.formModel.setMaxVersionLevel(FormModel.LATEST_VERSION);
            FormLAF.executeWithLookAndFeel(this.formModel, new Runnable(){

                @Override
                public void run() {
                    FormEditor.this.getResourceSupport().prepareNewForm();
                }
            });
            this.formModel.getSettings().getLayoutCodeTarget();
            this.formModel.fireFormChanged(true);
            try {
                this.formDataObject.getPrimaryFile().setAttribute("justCreatedByNewWizard", null);
                this.formDataObject.getPrimaryFile().setAttribute("nonEditableTemplate", null);
            }
            catch (IOException ex) {
                Logger.getLogger(FormEditor.class.getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
            return true;
        }
        return false;
    }

    FormDesigner getFormDesigner() {
        if (!this.formLoaded) {
            return null;
        }
        return this.formDesigner;
    }

    void setFormDesigner(FormDesigner designer) {
        this.formDesigner = designer;
    }

    public void closeForm() {
        if (this.formLoaded) {
            this.formModel.fireFormToBeClosed();
            openForms.remove(this.formModel);
            formModelToAssistant.remove(this.formModel);
            this.formLoaded = false;
            this.detachFormListener();
            this.detachDataObjectListener();
            this.detachPaletteListener();
            if (openForms.isEmpty()) {
                FormEditor.detachSettingsListener();
            }
            if (this.floatingWindows != null) {
                if (this.floatingWindows.size() > 0) {
                    LinkedList<Window> tempList = new LinkedList<Window>(this.floatingWindows);
                    for (Window window : tempList) {
                        if (!window.isVisible()) continue;
                        window.setVisible(false);
                    }
                }
                this.floatingWindows = null;
            }
            if (this.nodesWithPropertiesWindows != null) {
                for (FormNode n : this.nodesWithPropertiesWindows) {
                    n.fireNodeDestroyedHelper();
                }
            }
        }
        ClassPathUtils.releaseFormClassLoader(this.formDataObject.getPrimaryFile());
        ClassPathUtils.releaseFormClassLoader(this.formDataObject.getFormFile());
        this.formRootNode = null;
        this.formDesigner = null;
        this.persistenceManager = null;
        this.formModel = null;
        this.codeGenerator = null;
        this.formJavaSource = null;
        this.prefetchedSuperclassName = null;
        this.resourceSupport = null;
        this.bindingSupportInitialized = false;
        this.bindingSupport = null;
    }

    public void relocate(FormDataObject newDataObject) {
        this.detachDataObjectListener();
        this.detachPaletteListener();
        FormDataObject oldDataObject = this.formDataObject;
        this.formDataObject = newDataObject;
        this.formJavaSource = null;
        if (this.formLoaded) {
            String name = this.formDataObject.getName();
            this.formModel.setName(name);
            this.formRootNode.updateName(name);
            this.formModel.getCodeStructure().setFormJavaSource(this.getFormJavaSource(true));
            ClassPathUtils.getProjectClassLoader(newDataObject.getPrimaryFile());
            ClassPathUtils.releaseFormClassLoader(oldDataObject.getPrimaryFile());
            ClassPathUtils.releaseFormClassLoader(oldDataObject.getFormFile());
            this.attachDataObjectListener();
            this.attachPaletteListener();
            this.formModel.fireFormChanged(false);
        }
    }

    private void attachFormListener() {
        if (this.formListener != null || this.formDataObject.isReadOnly() || this.formModel.isReadOnly()) {
            return;
        }
        this.formListener = new FormModelListener(){

            @Override
            public void formChanged(FormModelEvent[] events) {
                if (events == null) {
                    return;
                }
                boolean justAfterLoading = false;
                boolean modifying = false;
                HashSet<ComponentContainer> changedContainers = events.length > 0 ? new HashSet<ComponentContainer>() : null;
                HashSet<RADComponent> compsToSelect = null;
                FormNode nodeToSelect = null;
                for (int i = 0; i < events.length; ++i) {
                    int type;
                    FormModelEvent ev = events[i];
                    if (ev.isModifying()) {
                        modifying = true;
                    }
                    if ((type = ev.getChangeType()) == 4 || type == 5 || type == 7 || type == 8 || type == 9) {
                        ComponentContainer cont = ev.getContainer();
                        if (changedContainers == null || !changedContainers.contains(cont)) {
                            FormEditor.this.updateNodeChildren(cont);
                            if (changedContainers != null) {
                                changedContainers.add(cont);
                            }
                        }
                        if (type == 8) {
                            FormNode select = cont instanceof RADComponent ? ((RADComponent)((Object)cont)).getNodeReference() : FormEditor.this.getOthersContainerNode();
                            if (!(nodeToSelect instanceof RADComponentNode)) {
                                if (nodeToSelect == FormEditor.this.formRootNode) continue;
                                nodeToSelect = select;
                                continue;
                            }
                            if (nodeToSelect == select) continue;
                            nodeToSelect = FormEditor.this.formRootNode;
                            continue;
                        }
                        if (type == 4) {
                            nodeToSelect = ((RADVisualContainer)cont).getLayoutNodeReference();
                            continue;
                        }
                        if (type != 7 || !ev.getComponent().isInModel()) continue;
                        if (compsToSelect == null) {
                            compsToSelect = new HashSet<RADComponent>();
                        }
                        compsToSelect.add(ev.getComponent());
                        compsToSelect.remove(ev.getContainer());
                        continue;
                    }
                    if (type != 1) continue;
                    justAfterLoading = true;
                }
                FormDesigner designer = FormEditor.this.getFormDesigner();
                if (designer != null) {
                    if (compsToSelect != null) {
                        RADComponent[] comps = new RADComponent[compsToSelect.size()];
                        compsToSelect.toArray(comps);
                        designer.setSelectedComponents(comps);
                    } else if (nodeToSelect != null) {
                        designer.setSelectedNodes(new Node[]{nodeToSelect});
                    }
                }
                if (modifying && (!justAfterLoading || FormEditor.this.needPostCreationUpdate() || FormEditor.this.formModel.isCompoundEditInProgress())) {
                    FormEditor.this.getEditorSupport().markModified();
                    FormEditor.this.checkFormVersionUpgrade();
                }
            }
        };
        this.formModel.addFormModelListener(this.formListener);
    }

    private void detachFormListener() {
        if (this.formListener != null) {
            this.formModel.removeFormModelListener(this.formListener);
            this.formListener = null;
        }
    }

    void updateNodeChildren(ComponentContainer metacont) {
        FormNode node = null;
        if (metacont == null || metacont == this.formModel.getModelContainer()) {
            node = this.formRootNode != null ? this.getOthersContainerNode() : null;
        } else if (metacont instanceof RADComponent) {
            node = ((RADComponent)((Object)metacont)).getNodeReference();
        }
        if (node != null) {
            node.updateChildren();
        }
    }

    private void checkFormVersionUpgrade() {
        FormModel.FormVersion currentVersion = this.formModel.getCurrentVersionLevel();
        FormModel.FormVersion maxVersion = this.formModel.getMaxVersionLevel();
        if (currentVersion.ordinal() > maxVersion.ordinal()) {
            if (EventQueue.isDispatchThread()) {
                this.processVersionUpgrade(true);
            } else {
                this.confirmVersionUpgrade();
            }
        }
    }

    private void processVersionUpgrade(boolean processingEvents) {
        if (!processingEvents && this.formModel.hasPendingEvents()) {
            processingEvents = true;
        }
        if (processingEvents) {
            if (!this.upgradeCheckPosted) {
                this.upgradeCheckPosted = true;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FormEditor.this.upgradeCheckPosted = false;
                        if (FormEditor.this.formModel != null) {
                            FormEditor.this.processVersionUpgrade(false);
                        }
                    }
                });
            }
        } else {
            String upgradeOption = FormUtils.getBundleString("CTL_UpgradeOption");
            String undoOption = FormUtils.getBundleString("CTL_CancelOption");
            NotifyDescriptor d = new NotifyDescriptor((Object)FormUtils.getBundleString("MSG_UpgradeQuestion"), FormUtils.getBundleString("TITLE_FormatUpgrade"), -1, 3, (Object[])new String[]{upgradeOption, undoOption}, (Object)upgradeOption);
            if (DialogDisplayer.getDefault().notify(d) == upgradeOption) {
                this.confirmVersionUpgrade();
            } else {
                this.revertVersionUpgrade();
            }
        }
    }

    private void confirmVersionUpgrade() {
        if (this.formModel != null) {
            this.formModel.confirmVersionLevel();
            this.formModel.setMaxVersionLevel(FormModel.LATEST_VERSION);
        }
    }

    private void revertVersionUpgrade() {
        if (this.formModel != null) {
            this.formModel.getUndoRedoManager().undo();
            this.formModel.revertVersionLevel();
        }
    }

    private void attachDataObjectListener() {
        if (this.dataObjectListener != null) {
            return;
        }
        this.dataObjectListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if ("name".equals(ev.getPropertyName())) {
                    String name = FormEditor.this.formDataObject.getName();
                    FormEditor.this.formModel.setName(name);
                    FormEditor.this.formRootNode.updateName(name);
                } else if ("cookie".equals(ev.getPropertyName()) && FormEditor.this.formDesigner != null) {
                    for (Node node : FormEditor.this.formDesigner.getSelectedNodes()) {
                        if (!(node instanceof FormNode)) continue;
                        ((FormNode)node).updateCookies();
                    }
                }
            }
        };
        this.formDataObject.addPropertyChangeListener(this.dataObjectListener);
    }

    private void detachDataObjectListener() {
        if (this.dataObjectListener != null) {
            this.formDataObject.removePropertyChangeListener(this.dataObjectListener);
            this.dataObjectListener = null;
        }
    }

    private static void attachSettingsListener() {
        if (settingsListener != null) {
            return;
        }
        settingsListener = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(final PreferenceChangeEvent evt) {
                if (EventQueue.isDispatchThread()) {
                    FormEditor.updateSettings(evt);
                } else {
                    EventQueue.invokeLater(new Runnable(){
                        final /* synthetic */ 7 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            FormEditor.updateSettings(evt);
                        }
                    });
                }
            }
        };
        FormLoaderSettings.getPreferences().addPreferenceChangeListener(settingsListener);
    }

    private static void updateSettings(PreferenceChangeEvent evt) {
        for (FormModel formModel : openForms.keySet()) {
            LayoutDesigner layoutDesigner;
            FormDesigner designer;
            String propName = evt.getKey();
            if ("useIndentEngine".equals(propName)) {
                formModel.fireSyntheticPropertyChanged(null, propName, null, evt.getNewValue());
                continue;
            }
            if ("selectionBorderSize".equals(propName) || "selectionBorderColor".equals(propName) || "connectionBorderColor".equals(propName) || "formDesignerBackgroundColor".equals(propName) || "formDesignerBorderColor".equals(propName) || "guidingLineColor".equals(propName)) {
                designer = FormEditor.getFormDesigner(formModel);
                if (designer == null) continue;
                designer.updateVisualSettings();
                continue;
            }
            if ("toolBarPalette".equals(propName)) {
                designer = FormEditor.getFormDesigner(formModel);
                if (designer == null) continue;
                designer.getFormToolBar().showPaletteButton(FormLoaderSettings.getInstance().isPaletteInToolBar());
                continue;
            }
            if (!"paintAdvancedLayout".equals(propName) || (designer = FormEditor.getFormDesigner(formModel)) == null || (layoutDesigner = designer.getLayoutDesigner()) == null) continue;
            int paintLayout = FormLoaderSettings.getInstance().getPaintAdvancedLayoutInfo();
            layoutDesigner.setPaintAlignment((paintLayout & 1) != 0);
            layoutDesigner.setPaintGaps((paintLayout & 2) != 0);
            designer.getHandleLayer().repaint();
        }
    }

    private static void detachSettingsListener() {
        if (settingsListener != null) {
            FormLoaderSettings.getPreferences().removePreferenceChangeListener(settingsListener);
            settingsListener = null;
        }
    }

    private void attachPaletteListener() {
        if (this.paletteListener != null) {
            return;
        }
        this.paletteListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedItem".equals(evt.getPropertyName())) {
                    FormDesigner designer;
                    FormModel formModel = FormEditor.this.getFormModel();
                    if (FormEditor.this.isFormLoaded() && formModel != null && !formModel.isReadOnly() && (designer = FormEditor.getFormDesigner(formModel)) != null) {
                        if (evt.getNewValue() == null) {
                            if (designer.getDesignerMode() == 2) {
                                designer.setDesignerMode(0);
                            }
                        } else {
                            if (designer.getDesignerMode() == 2) {
                                designer.setDesignerMode(0);
                            }
                            designer.setDesignerMode(2);
                        }
                    }
                }
            }
        };
        PaletteUtils.addPaletteListener(this.paletteListener, this.formDataObject.getPrimaryFile());
    }

    private void detachPaletteListener() {
        if (this.paletteListener != null) {
            PaletteUtils.removePaletteListener(this.paletteListener, this.formDataObject.getPrimaryFile());
            this.paletteListener = null;
        }
    }

    void reinstallListener() {
        if (this.formListener != null) {
            this.formModel.removeFormModelListener(this.formListener);
            this.formModel.addFormModelListener(this.formListener);
        }
    }

    public static JEditorPane createCodeEditorPane(FormModel formModel) {
        FormEditor formEditor = FormEditor.getFormEditor(formModel);
        JavaCodeGenerator codeGen = (JavaCodeGenerator)formEditor.getCodeGenerator();
        codeGen.regenerateCode();
        JEditorPane codePane = new JEditorPane();
        SimpleSection sec = formEditor.getInitComponentSection();
        int pos = sec.getText().indexOf(123) + 2 + sec.getStartPosition().getOffset();
        FormUtils.setupEditorPane(codePane, formEditor.getFormDataObject().getPrimaryFile(), pos);
        return codePane;
    }

    public static synchronized AssistantModel getAssistantModel(FormModel formModel) {
        assert (formModel != null);
        AssistantModel assistant = formModelToAssistant.get(formModel);
        if (assistant == null) {
            assistant = new AssistantModel();
            formModelToAssistant.put(formModel, assistant);
        }
        return assistant;
    }

    public static FormDesigner getFormDesigner(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getFormDesigner() : null;
    }

    public static CodeGenerator getCodeGenerator(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getCodeGenerator() : null;
    }

    public static FormDataObject getFormDataObject(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getFormDataObject() : null;
    }

    public static FormJavaSource getFormJavaSource(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getFormJavaSource() : null;
    }

    static ResourceSupport getResourceSupport(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getResourceSupport() : null;
    }

    public static BindingDesignSupport getBindingSupport(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getBindingSupport() : null;
    }

    public static FormEditor getFormEditor(FormModel formModel) {
        return openForms.get(formModel);
    }

    UndoRedo.Manager getFormUndoRedoManager() {
        return this.formModel != null ? this.formModel.getUndoRedoManager() : null;
    }

    public void registerFloatingWindow(Window window) {
        if (this.floatingWindows == null) {
            this.floatingWindows = new ArrayList<Window>();
        } else {
            this.floatingWindows.remove(window);
        }
        this.floatingWindows.add(window);
    }

    public void unregisterFloatingWindow(Window window) {
        if (this.floatingWindows != null) {
            this.floatingWindows.remove(window);
        }
    }

    void registerNodeWithPropertiesWindow(FormNode node) {
        if (this.nodesWithPropertiesWindows == null) {
            this.nodesWithPropertiesWindows = new WeakSet();
        }
        this.nodesWithPropertiesWindows.add(node);
    }

    public void registerDefaultComponentAction(Action action) {
        if (this.defaultActions == null) {
            this.createDefaultComponentActionsList();
        } else {
            this.defaultActions.remove(action);
        }
        this.defaultActions.add(0, action);
    }

    public void unregisterDefaultComponentAction(Action action) {
        if (this.defaultActions != null) {
            this.defaultActions.remove(action);
        }
    }

    private void createDefaultComponentActionsList() {
        this.defaultActions = new LinkedList<Action>();
        this.defaultActions.add((Action)SystemAction.get(CustomizeEmptySpaceAction.EditSingleGapAction.class));
        this.defaultActions.add((Action)SystemAction.get(EditContainerAction.class));
        this.defaultActions.add((Action)SystemAction.get(EditFormAction.class));
        this.defaultActions.add((Action)SystemAction.get(DefaultRADAction.class));
    }

    Collection<Action> getDefaultComponentActions() {
        if (this.defaultActions == null) {
            this.createDefaultComponentActionsList();
        }
        return Collections.unmodifiableList(this.defaultActions);
    }

    public static boolean updateProjectForNaturalLayout(FormModel formModel) {
        FormEditor formEditor = FormEditor.getFormEditor(formModel);
        if (formEditor != null && formModel.getSettings().getLayoutCodeTarget() != 1 && !ClassPathUtils.isOnClassPath(formEditor.getFormDataObject().getFormFile(), "org.jdesktop.layout.GroupLayout")) {
            try {
                ClassSource cs = new ClassSource("", ClassSource.unpickle("library", "swing-layout"));
                return Boolean.TRUE == ClassPathUtils.updateProject(formEditor.getFormDataObject().getFormFile(), cs, true);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (RuntimeException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return false;
    }

    public static boolean updateProjectForBeansBinding(FormModel formModel) {
        FormEditor formEditor = FormEditor.getFormEditor(formModel);
        if (formEditor != null) {
            return formEditor.getBindingSupport().updateProjectForBeansBinding();
        }
        return false;
    }

    public static boolean isNonVisualTrayEnabled() {
        return Boolean.getBoolean("netbeans.form.non_visual_tray");
    }
}

