/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.actions.Bundle;
import org.netbeans.modules.project.dependency.ProjectReload;
import org.openide.awt.StatusDisplayer;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;

public class RefreshAction
extends AbstractAction
implements ContextAwareAction {
    private final Lookup context;

    public RefreshAction() {
        this(Lookup.EMPTY);
    }

    private RefreshAction(Lookup lkp) {
        this.context = lkp;
        Collection col = this.context.lookupAll(NbMavenProjectImpl.class);
        if (col.size() > 1) {
            this.putValue("Name", Bundle.ACT_Reload_Projects(col.size()));
        } else {
            this.putValue("Name", Bundle.ACT_Reload_Project());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        for (NbMavenProjectImpl prj : this.context.lookupAll(NbMavenProjectImpl.class)) {
            CompletableFuture f = ProjectReload.withProjectState((Project)prj, (ProjectReload.StateRequest)ProjectReload.StateRequest.reload().saveModifications().toQuality(ProjectReload.Quality.SIMPLE));
            f.whenComplete((s, err) -> {
                if (err instanceof CompletionException) {
                    err = err.getCause();
                }
                if (err != null) {
                    StatusDisplayer.getDefault().setStatusText(err.getMessage());
                }
            });
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new RefreshAction(actionContext);
    }
}

