/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.monitoring.model.Alarm;
import com.oracle.bmc.monitoring.model.Suppression;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AlarmSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="metricCompartmentId")
    private final String metricCompartmentId;
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="query")
    private final String query;
    @JsonProperty(value="severity")
    private final Severity severity;
    @JsonProperty(value="destinations")
    private final List<String> destinations;
    @JsonProperty(value="suppression")
    private final Suppression suppression;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="lifecycleState")
    private final Alarm.LifecycleState lifecycleState;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "metricCompartmentId", "namespace", "query", "severity", "destinations", "suppression", "isEnabled", "freeformTags", "definedTags", "lifecycleState"})
    public AlarmSummary(String id, String displayName, String compartmentId, String metricCompartmentId, String namespace, String query, Severity severity, List<String> destinations, Suppression suppression, Boolean isEnabled, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Alarm.LifecycleState lifecycleState) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.metricCompartmentId = metricCompartmentId;
        this.namespace = namespace;
        this.query = query;
        this.severity = severity;
        this.destinations = destinations;
        this.suppression = suppression;
        this.isEnabled = isEnabled;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getMetricCompartmentId() {
        return this.metricCompartmentId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getQuery() {
        return this.query;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public List<String> getDestinations() {
        return this.destinations;
    }

    public Suppression getSuppression() {
        return this.suppression;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Alarm.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AlarmSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", metricCompartmentId=").append(String.valueOf(this.metricCompartmentId));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", query=").append(String.valueOf(this.query));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(", destinations=").append(String.valueOf(this.destinations));
        sb.append(", suppression=").append(String.valueOf((Object)this.suppression));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlarmSummary)) {
            return false;
        }
        AlarmSummary other = (AlarmSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.metricCompartmentId, other.metricCompartmentId) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.query, other.query) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals(this.destinations, other.destinations) && Objects.equals((Object)this.suppression, (Object)other.suppression) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.metricCompartmentId == null ? 43 : this.metricCompartmentId.hashCode());
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.query == null ? 43 : this.query.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.destinations == null ? 43 : this.destinations.hashCode());
        result = result * 59 + (this.suppression == null ? 43 : this.suppression.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Severity implements BmcEnum
    {
        Critical("CRITICAL"),
        Error("ERROR"),
        Warning("WARNING"),
        Info("INFO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Severity> map;

        private Severity(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Severity create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Severity', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Severity.class);
            map = new HashMap<String, Severity>();
            for (Severity v : Severity.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="metricCompartmentId")
        private String metricCompartmentId;
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="query")
        private String query;
        @JsonProperty(value="severity")
        private Severity severity;
        @JsonProperty(value="destinations")
        private List<String> destinations;
        @JsonProperty(value="suppression")
        private Suppression suppression;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="lifecycleState")
        private Alarm.LifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder metricCompartmentId(String metricCompartmentId) {
            this.metricCompartmentId = metricCompartmentId;
            this.__explicitlySet__.add("metricCompartmentId");
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            this.__explicitlySet__.add("query");
            return this;
        }

        public Builder severity(Severity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder destinations(List<String> destinations) {
            this.destinations = destinations;
            this.__explicitlySet__.add("destinations");
            return this;
        }

        public Builder suppression(Suppression suppression) {
            this.suppression = suppression;
            this.__explicitlySet__.add("suppression");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder lifecycleState(Alarm.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public AlarmSummary build() {
            AlarmSummary model = new AlarmSummary(this.id, this.displayName, this.compartmentId, this.metricCompartmentId, this.namespace, this.query, this.severity, this.destinations, this.suppression, this.isEnabled, this.freeformTags, this.definedTags, this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AlarmSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("metricCompartmentId")) {
                this.metricCompartmentId(model.getMetricCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("query")) {
                this.query(model.getQuery());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("destinations")) {
                this.destinations(model.getDestinations());
            }
            if (model.wasPropertyExplicitlySet("suppression")) {
                this.suppression(model.getSuppression());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }
}

