/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.actions;

import com.sun.jdi.ObjectReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.RemoteAWTScreenshot;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.AWTComponentBreakpoint;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.ComponentBreakpoint;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.FXComponentBreakpoint;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

public class ComponentBreakpointActionProvider
extends ActionsProviderSupport {
    public ComponentBreakpointActionProvider() {
        final Lookup.Result nodeLookupResult = Utilities.actionsGlobalContext().lookupResult(Node.class);
        LookupListener ll = new LookupListener(){
            final /* synthetic */ ComponentBreakpointActionProvider this$0;
            {
                this.this$0 = this$0;
            }

            public void resultChanged(LookupEvent ev) {
                Collection nodeInstances = nodeLookupResult.allInstances();
                for (Node n : nodeInstances) {
                    JavaComponentInfo ci = (JavaComponentInfo)n.getLookup().lookup(JavaComponentInfo.class);
                    if (ci == null) continue;
                    this.this$0.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, true);
                    return;
                }
                this.this$0.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
            }
        };
        nodeLookupResult.addLookupListener(ll);
        ll.resultChanged(null);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void doAction(Object action) {
        Collection activatedNodes = Utilities.actionsGlobalContext().lookupAll(Node.class);
        ComponentBreakpointActionProvider.doAction(activatedNodes.toArray(new Node[0]));
    }

    static void doAction(Node[] activatedNodes) {
        for (Node n : activatedNodes) {
            JavaComponentInfo ci = (JavaComponentInfo)n.getLookup().lookup(JavaComponentInfo.class);
            if (ci == null) continue;
            ObjectReference component = ci.getComponent();
            ComponentBreakpoint b = ComponentBreakpointActionProvider.findBreakpoint(component);
            if (b == null) {
                JPDADebuggerImpl debugger = ci.getThread().getDebugger();
                b = ci instanceof RemoteAWTScreenshot.AWTComponentInfo ? new AWTComponentBreakpoint(new ComponentBreakpoint.ComponentDescription(ci, (JPDADebugger)debugger, component)) : new FXComponentBreakpoint(new ComponentBreakpoint.ComponentDescription(ci, (JPDADebugger)debugger, component));
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)b);
                continue;
            }
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)b);
        }
    }

    public static ComponentBreakpoint findBreakpoint(ObjectReference component) {
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpoints.length; ++i) {
            JPDADebugger debugger;
            if (!(breakpoints[i] instanceof ComponentBreakpoint)) continue;
            ComponentBreakpoint ab = (ComponentBreakpoint)breakpoints[i];
            Session currentSession = DebuggerManager.getDebuggerManager().getCurrentSession();
            if (currentSession == null || (debugger = (JPDADebugger)currentSession.lookupFirst(null, JPDADebugger.class)) == null || !component.equals(ab.getComponent().getComponent(debugger))) continue;
            return ab;
        }
        return null;
    }
}

