/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut;

import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.textmate.lexer.api.GrammarRegistration;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

@GrammarRegistration(mimeType="text/x-micronaut-el", grammar="./resources/mexp.tmLanguage.json")
public enum MicronautExpressionLanguageTokenId implements TokenId
{
    EXPRESSION_LANGUAGE,
    STRING;

    private static final Language<?> micronautExpressionLanguage;
    private static final Language<?> javaString;
    private static final Language<MicronautExpressionLanguageTokenId> language;

    public String primaryCategory() {
        return "string";
    }

    public static Language<MicronautExpressionLanguageTokenId> language() {
        return language;
    }

    static {
        micronautExpressionLanguage = Language.find((String)"text/x-micronaut-el");
        javaString = Language.find((String)"text/x-java-string");
        language = new LanguageHierarchy<MicronautExpressionLanguageTokenId>(){

            protected String mimeType() {
                return "text/x-micronaut-el-wrapper";
            }

            protected Collection<MicronautExpressionLanguageTokenId> createTokenIds() {
                return EnumSet.allOf(MicronautExpressionLanguageTokenId.class);
            }

            protected Lexer<MicronautExpressionLanguageTokenId> createLexer(LexerRestartInfo<MicronautExpressionLanguageTokenId> info) {
                return new MicronautExpressionLanguageLexer(info);
            }

            protected LanguageEmbedding<?> embedding(Token<MicronautExpressionLanguageTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                switch (((MicronautExpressionLanguageTokenId)token.id()).ordinal()) {
                    case 0: {
                        return micronautExpressionLanguage != null ? LanguageEmbedding.create((Language)micronautExpressionLanguage, (int)0, (int)0) : null;
                    }
                    case 1: {
                        return javaString != null ? LanguageEmbedding.create((Language)javaString, (int)0, (int)0) : null;
                    }
                }
                return null;
            }
        }.language();
    }

    private static class MicronautExpressionLanguageEmbeddingProvider
    extends JavaParserResultTask<Parser.Result> {
        private static final String EXPRESSION_CLASS = "io.micronaut.core.expressions.EvaluatedExpression";
        private final AtomicBoolean canceled = new AtomicBoolean();

        private MicronautExpressionLanguageEmbeddingProvider() {
            super(JavaSource.Phase.ELEMENTS_RESOLVED);
        }

        public void run(Parser.Result result, SchedulerEvent event) {
            TypeElement expression;
            CompilationInfo ci = CompilationInfo.get((Parser.Result)result);
            if (ci != null && !this.canceled.get() && (expression = ci.getElements().getTypeElement(EXPRESSION_CLASS)) != null) {
                ArrayList literalBounds = new ArrayList();
                final SourcePositions sp = ci.getTrees().getSourcePositions();
                new TreePathScanner<Void, List<Pair<Integer, Integer>>>(this){
                    final /* synthetic */ MicronautExpressionLanguageEmbeddingProvider this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public Void visitLiteral(LiteralTree node, List<Pair<Integer, Integer>> p) {
                        TreePath path;
                        if (!this.this$0.canceled.get() && node.getValue() instanceof String && (path = this.getCurrentPath()).getParentPath() != null && path.getParentPath().getLeaf().getKind() == Tree.Kind.ASSIGNMENT && path.getParentPath().getParentPath() != null && path.getParentPath().getParentPath().getLeaf().getKind() == Tree.Kind.ANNOTATION) {
                            p.add((Pair<Integer, Integer>)Pair.of((Object)((int)sp.getStartPosition(path.getCompilationUnit(), node)), (Object)((int)sp.getEndPosition(path.getCompilationUnit(), node))));
                        }
                        return null;
                    }
                }.scan(ci.getCompilationUnit(), literalBounds);
                if (!literalBounds.isEmpty()) {
                    try {
                        Document doc = ci.getDocument();
                        if (doc != null) {
                            RequestProcessor.getDefault().post(() -> {
                                Runnable runn = () -> {
                                    TokenSequence ts;
                                    TokenHierarchy hierarchy = TokenHierarchy.get((Document)doc);
                                    Language java = Language.find((String)"text/x-java");
                                    if (java != null && micronautExpressionLanguage != null && (ts = hierarchy.tokenSequence(java)) != null) {
                                        for (Pair bound : literalBounds) {
                                            ts.move(((Integer)bound.first()).intValue());
                                            while (ts.moveNext() && ts.offset() < (Integer)bound.second()) {
                                                TokenSequence embedded = ts.embedded();
                                                if (embedded != null) {
                                                    if (!"text/x-java-string".equals(embedded.language().mimeType())) continue;
                                                    ts.removeEmbedding(embedded.language());
                                                    ts.createEmbedding(MicronautExpressionLanguageTokenId.language(), 1, 1, true);
                                                    continue;
                                                }
                                                ts.createEmbedding(MicronautExpressionLanguageTokenId.language(), 1, 1, true);
                                            }
                                        }
                                    }
                                };
                                ((AtomicLockDocument)LineDocumentUtils.asRequired((Document)doc, AtomicLockDocument.class)).runAtomic(runn);
                            });
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }

        public int getPriority() {
            return 999;
        }

        public Class<? extends Scheduler> getSchedulerClass() {
            return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
        }

        public void cancel() {
            this.canceled.set(true);
        }
    }

    private static class MicronautExpressionLanguageLexer
    implements Lexer {
        private final LexerRestartInfo<MicronautExpressionLanguageTokenId> info;
        private boolean insideEL;

        private MicronautExpressionLanguageLexer(LexerRestartInfo<MicronautExpressionLanguageTokenId> info) {
            this.info = info;
        }

        public Token nextToken() {
            int c;
            while ((c = this.info.input().read()) != -1) {
                if (this.insideEL && c == 125) {
                    this.insideEL = false;
                    return this.info.tokenFactory().createToken((TokenId)EXPRESSION_LANGUAGE, this.info.input().readLength() - 1);
                }
                if (!this.info.input().readText().toString().endsWith("#{")) continue;
                this.insideEL = true;
                return this.info.tokenFactory().createToken((TokenId)STRING, this.info.input().readLength());
            }
            if (this.info.input().readLength() == 0) {
                return null;
            }
            return this.info.tokenFactory().createToken((TokenId)STRING);
        }

        public Object state() {
            return this.insideEL;
        }

        public void release() {
        }
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singleton(new MicronautExpressionLanguageEmbeddingProvider());
        }
    }
}

