/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class FreeformSources
implements Sources,
AntProjectListener {
    private final FreeformProject project;
    private volatile Sources delegate;
    private final Map<File, FileChangeListener> listenOnFiles = Collections.synchronizedMap(new HashMap());
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    public FreeformSources(FreeformProject project) {
        this.project = project;
        project.helper().addAntProjectListener((AntProjectListener)this);
        this.initSources();
    }

    public SourceGroup[] getSourceGroups(final String type) {
        return (SourceGroup[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceGroup[]>(){
            final /* synthetic */ FreeformSources this$0;
            {
                this.this$0 = this$0;
            }

            public SourceGroup[] run() {
                if (this.this$0.delegate == null) {
                    this.this$0.delegate = this.this$0.initSources();
                }
                return this.this$0.delegate.getSourceGroups(type);
            }
        });
    }

    private Sources initSources() {
        SourcesHelper h = new SourcesHelper((Project)this.project, this.project.helper(), this.project.evaluator());
        Element genldata = this.project.getPrimaryConfigurationData();
        Element foldersE = XMLUtil.findElement((Element)genldata, (String)"folders", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (foldersE != null) {
            ArrayList<File> newFiles = new ArrayList<File>();
            for (Element folderE : XMLUtil.findSubElements((Element)foldersE)) {
                Element locationE = XMLUtil.findElement((Element)folderE, (String)"location", (String)"http://www.netbeans.org/ns/freeform-project/2");
                String location = XMLUtil.findText((Node)locationE);
                String locationEval = this.project.evaluator().evaluate(location);
                if (locationEval != null) {
                    newFiles.add(this.project.helper().resolveFile(locationEval));
                }
                if (folderE.getLocalName().equals("build-folder")) {
                    h.addNonSourceRoot(location);
                    continue;
                }
                if (folderE.getLocalName().equals("build-file")) {
                    h.addOwnedFile(location);
                    continue;
                }
                assert (folderE.getLocalName().equals("source-folder")) : folderE;
                Element nameE = XMLUtil.findElement((Element)folderE, (String)"label", (String)"http://www.netbeans.org/ns/freeform-project/2");
                String name = XMLUtil.findText((Node)nameE);
                Element typeE = XMLUtil.findElement((Element)folderE, (String)"type", (String)"http://www.netbeans.org/ns/freeform-project/2");
                String includes = null;
                Element includesE = XMLUtil.findElement((Element)folderE, (String)"includes", (String)"http://www.netbeans.org/ns/freeform-project/2");
                if (includesE != null) {
                    includes = XMLUtil.findText((Node)includesE);
                }
                String excludes = null;
                Element excludesE = XMLUtil.findElement((Element)folderE, (String)"excludes", (String)"http://www.netbeans.org/ns/freeform-project/2");
                if (excludesE != null) {
                    excludes = XMLUtil.findText((Node)excludesE);
                }
                if (typeE != null) {
                    String type = XMLUtil.findText((Node)typeE);
                    h.addTypedSourceRoot(location, includes, excludes, type, name, null, null);
                    continue;
                }
                h.addPrincipalSourceRoot(location, includes, excludes, name, null, null);
            }
            this.updateFileListeners(newFiles);
        }
        h.registerExternalRoots(0);
        return h.createSources();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.reset();
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFileListeners(List<? extends File> newFiles) {
        Map<File, FileChangeListener> map = this.listenOnFiles;
        synchronized (map) {
            HashSet<File> toRemove = new HashSet<File>(this.listenOnFiles.keySet());
            toRemove.removeAll(newFiles);
            HashSet<? extends File> toAdd = new HashSet<File>(newFiles);
            toAdd.removeAll(this.listenOnFiles.keySet());
            for (File file : toRemove) {
                FileChangeListener fcl = this.listenOnFiles.remove(file);
                FileUtil.removeFileChangeListener((FileChangeListener)fcl, (File)file);
            }
            for (File file : toAdd) {
                WeakFileListener wl = new WeakFileListener(this, file);
                this.listenOnFiles.put(file, wl);
                FileUtil.addFileChangeListener((FileChangeListener)wl, (File)file);
            }
        }
    }

    private void resetIfNeeded(FileObject fo) {
        File parentFile;
        FileObject parent = fo.getParent();
        if (parent != null && (parentFile = FileUtil.toFile((FileObject)parent)) != null && this.listenOnFiles.containsKey(parentFile)) {
            return;
        }
        this.reset();
    }

    private void reset() {
        this.delegate = null;
        this.cs.fireChange();
    }

    private class WeakFileListener
    extends WeakReference<FreeformSources>
    implements Runnable,
    FileChangeListener {
        private final File file;

        private WeakFileListener(FreeformSources source, File file) {
            super(source, Utilities.activeReferenceQueue());
            this.file = file;
        }

        @Override
        public void run() {
            FileUtil.removeFileChangeListener((FileChangeListener)this, (File)this.file);
        }

        public void fileFolderCreated(FileEvent fe) {
            FreeformSources.this.resetIfNeeded(fe.getFile());
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            FreeformSources.this.resetIfNeeded(fe.getFile());
        }

        public void fileRenamed(FileRenameEvent fe) {
            FreeformSources.this.resetIfNeeded(fe.getFile());
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

