/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.knockout;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.knockout.KOUtils;
import org.netbeans.modules.javascript2.knockout.index.KnockoutCustomElement;

public class KOTagCompletionItem
extends HtmlCompletionItem.Tag {
    private final KnockoutCustomElement element;
    private final List<String> alternativeLocations = new ArrayList<String>();

    public KOTagCompletionItem(KnockoutCustomElement element, int substitutionOffset) {
        super(element.getName(), substitutionOffset, null, true);
        this.element = element;
    }

    protected ImageIcon getIcon() {
        return KOUtils.KO_ICON;
    }

    public String getHelp() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h1>");
        sb.append(this.element.getName());
        sb.append("</h1>");
        sb.append("<h2>Custom Knockout element</h2>");
        File file = new File(this.element.getDeclarationFile().toString());
        sb.append("<p>");
        sb.append("Registered in ");
        sb.append(file.getName());
        for (String loc : this.alternativeLocations) {
            sb.append(", ");
            sb.append(loc);
        }
        sb.append("</p>");
        return sb.toString();
    }

    public boolean hasHelp() {
        return true;
    }

    public String getCustomElementName() {
        return this.element.getName();
    }

    public void addAlternativeLocation(URL url) {
        File file = new File(url.toString());
        if (!this.element.getDeclarationFile().equals(url) && !this.alternativeLocations.contains(file.getName())) {
            this.alternativeLocations.add(file.getName());
        }
    }
}

