/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffprobe.data;

import com.github.kokorin.jaffree.ffprobe.data.AbstractProbeData;
import com.github.kokorin.jaffree.ffprobe.data.FormatParser;
import com.github.kokorin.jaffree.ffprobe.data.ProbeData;
import com.github.kokorin.jaffree.util.LineIterator;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FlatFormatParser
implements FormatParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlatFormatParser.class);

    @Override
    public String getFormatName() {
        return "flat";
    }

    @Override
    public ProbeData parse(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        LineIterator lines = new LineIterator(reader);
        TreeMap<String, Object> data = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        while (lines.hasNext()) {
            String line = (String)lines.next();
            try {
                String[] keyValue = line.split("=", 2);
                if (keyValue.length < 2) {
                    LOGGER.warn("Failed to parse line: {}", (Object)line);
                    continue;
                }
                String key = keyValue[0];
                String value = keyValue[1];
                boolean success = this.setKeyValue(data, key, value);
                if (!success) {
                    LOGGER.warn("Failed to set value: {}", (Object)key);
                    continue;
                }
                LOGGER.debug("Parsed: {} = {}", (Object)key, (Object)value);
            }
            catch (Exception e) {
                LOGGER.warn("Exception during parsing, ignored: {}", (Object)e.getMessage());
            }
        }
        return new ProbeDataMap(data);
    }

    protected boolean setKeyValue(TreeMap<String, Object> data, String key, String value) {
        Path step;
        int inc;
        String[] pathStr = key.split("\\.");
        ArrayList<Path> path = new ArrayList<Path>();
        for (int i = 0; i < pathStr.length; i += inc) {
            step = null;
            inc = 1;
            if (i + 2 < pathStr.length && (step = SectionPath.parse(pathStr[i], pathStr[i + 1], pathStr[i + 2])) != null) {
                inc = 3;
            }
            if (step == null && i == pathStr.length - 1) {
                step = new PropertyPath(pathStr[i]);
            }
            if (step == null && i <= pathStr.length - 2) {
                step = new TagPath(pathStr[i]);
            }
            if (step == null) {
                LOGGER.warn("Failed to parse path: {}", (Object)key);
            }
            path.add(step);
        }
        if (path.isEmpty()) {
            LOGGER.warn("Parsed path is empty: {}", (Object)key);
            return false;
        }
        TreeMap<String, Object> current = data;
        step = null;
        Iterator iterator = path.iterator();
        while (iterator.hasNext()) {
            Path p;
            step = p = (Path)iterator.next();
            current = step.next(current);
        }
        String fixedValue = this.fixValue(value);
        return step.set(current, fixedValue);
    }

    protected String fixValue(String value) {
        String unquotedValue = value;
        if (value.startsWith("\"") && value.endsWith("\"")) {
            unquotedValue = value.substring(1, value.length() - 1);
        }
        return unquotedValue.replaceAll("\\\\n", "\n");
    }

    private static boolean isNumeric(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static final class ProbeDataMap
    extends AbstractProbeData
    implements ProbeData {
        private final Map<String, Object> data;

        public ProbeDataMap(Map<String, Object> data) {
            this.data = data;
        }

        @Override
        public Object getValue(String name) {
            return this.data.get(name);
        }

        @Override
        public ProbeData getSubData(String name) {
            Object value = this.data.get(name);
            if (value == null) {
                return null;
            }
            if (!(value instanceof Map)) {
                throw new RuntimeException("Not a Map: " + value);
            }
            return new ProbeDataMap((Map)value);
        }

        @Override
        public List<ProbeData> getSubDataList(String name) {
            Object value = this.data.get(name);
            if (value == null) {
                return null;
            }
            if (!(value instanceof List)) {
                throw new RuntimeException("Not a List: " + value);
            }
            List valueList = (List)value;
            ArrayList<ProbeData> result = new ArrayList<ProbeData>(valueList.size());
            for (Object item : valueList) {
                if (!(item instanceof Map)) {
                    throw new RuntimeException("No a Map: " + item);
                }
                result.add(new ProbeDataMap((Map)item));
            }
            return result;
        }
    }

    private static class SectionPath
    implements Path {
        private final String section;
        private final String element;
        private final Integer index;

        SectionPath(String section, String element, Integer index) {
            this.section = section;
            this.element = element;
            this.index = index;
        }

        @Override
        public TreeMap<String, Object> next(TreeMap<String, Object> prev) {
            TreeMap result;
            ArrayList<TreeMap> valueList = (ArrayList<TreeMap>)prev.get(this.section);
            if (valueList == null) {
                valueList = new ArrayList<TreeMap>();
                prev.put(this.section, valueList);
            }
            Object lastElement = prev.get("_last_element");
            Object lastIndex = prev.get("_last_index");
            if (this.element.equals(lastElement) && this.index.equals(lastIndex)) {
                result = (TreeMap)valueList.get(valueList.size() - 1);
            } else {
                result = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                result.put("type", this.element);
                valueList.add(result);
                prev.put("_last_element", this.element);
                prev.put("_last_index", this.index);
            }
            return result;
        }

        @Override
        public boolean set(TreeMap<String, Object> current, String value) {
            return false;
        }

        public static SectionPath parse(String group, String name, String index) {
            if (!FlatFormatParser.isNumeric(index)) {
                return null;
            }
            return new SectionPath(group, name, Integer.valueOf(index));
        }
    }

    private static class PropertyPath
    implements Path {
        private final String name;

        PropertyPath(String name) {
            this.name = name;
        }

        @Override
        public TreeMap<String, Object> next(TreeMap<String, Object> prev) {
            return prev;
        }

        @Override
        public boolean set(TreeMap<String, Object> current, String value) {
            if (current != null) {
                current.put(this.name, value);
                return true;
            }
            return false;
        }

        public static PropertyPath parse(String name) {
            return new PropertyPath(name);
        }
    }

    private static class TagPath
    implements Path {
        private final String name;

        TagPath(String name) {
            this.name = name;
        }

        @Override
        public TreeMap<String, Object> next(TreeMap<String, Object> prev) {
            TreeMap result = (TreeMap)prev.get(this.name);
            if (result == null) {
                result = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                prev.put(this.name, result);
            }
            return result;
        }

        @Override
        public boolean set(TreeMap<String, Object> current, String value) {
            return false;
        }
    }

    private static interface Path {
        public TreeMap<String, Object> next(TreeMap<String, Object> var1);

        public boolean set(TreeMap<String, Object> var1, String var2);
    }
}

