/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce.srp;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.util.BigIntegers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SRP6Util {
    private static final byte[] colon = new byte[]{58};
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private static BigInteger ONE = BigInteger.valueOf(1L);

    SRP6Util() {
    }

    public static BigInteger calculateK(TlsHash tlsHash, BigInteger bigInteger, BigInteger bigInteger2) {
        return SRP6Util.hashPaddedPair(tlsHash, bigInteger, bigInteger, bigInteger2);
    }

    public static BigInteger calculateU(TlsHash tlsHash, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return SRP6Util.hashPaddedPair(tlsHash, bigInteger, bigInteger2, bigInteger3);
    }

    public static BigInteger calculateX(TlsHash tlsHash, BigInteger bigInteger, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        tlsHash.update(byArray2, 0, byArray2.length);
        tlsHash.update(colon, 0, 1);
        tlsHash.update(byArray3, 0, byArray3.length);
        byte[] byArray4 = tlsHash.calculateHash();
        tlsHash.update(byArray, 0, byArray.length);
        tlsHash.update(byArray4, 0, byArray4.length);
        return new BigInteger(1, tlsHash.calculateHash());
    }

    public static BigInteger generatePrivateValue(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        int n = Math.min(256, bigInteger.bitLength() / 2);
        BigInteger bigInteger3 = ONE.shiftLeft(n - 1);
        BigInteger bigInteger4 = bigInteger.subtract(ONE);
        return BigIntegers.createRandomInRange((BigInteger)bigInteger3, (BigInteger)bigInteger4, (SecureRandom)secureRandom);
    }

    public static BigInteger validatePublicValue(BigInteger bigInteger, BigInteger bigInteger2) throws IllegalArgumentException {
        if ((bigInteger2 = bigInteger2.mod(bigInteger)).equals(ZERO)) {
            throw new IllegalArgumentException("Invalid public value: 0");
        }
        return bigInteger2;
    }

    public static BigInteger calculateM1(TlsHash tlsHash, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        BigInteger bigInteger5 = SRP6Util.hashPaddedTriplet(tlsHash, bigInteger, bigInteger2, bigInteger3, bigInteger4);
        return bigInteger5;
    }

    public static BigInteger calculateM2(TlsHash tlsHash, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        BigInteger bigInteger5 = SRP6Util.hashPaddedTriplet(tlsHash, bigInteger, bigInteger2, bigInteger3, bigInteger4);
        return bigInteger5;
    }

    public static BigInteger calculateKey(TlsHash tlsHash, BigInteger bigInteger, BigInteger bigInteger2) {
        int n = (bigInteger.bitLength() + 7) / 8;
        byte[] byArray = SRP6Util.getPadded(bigInteger2, n);
        tlsHash.update(byArray, 0, byArray.length);
        return new BigInteger(1, tlsHash.calculateHash());
    }

    private static BigInteger hashPaddedTriplet(TlsHash tlsHash, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        int n = (bigInteger.bitLength() + 7) / 8;
        byte[] byArray = SRP6Util.getPadded(bigInteger2, n);
        byte[] byArray2 = SRP6Util.getPadded(bigInteger3, n);
        byte[] byArray3 = SRP6Util.getPadded(bigInteger4, n);
        tlsHash.update(byArray, 0, byArray.length);
        tlsHash.update(byArray2, 0, byArray2.length);
        tlsHash.update(byArray3, 0, byArray3.length);
        return new BigInteger(1, tlsHash.calculateHash());
    }

    private static BigInteger hashPaddedPair(TlsHash tlsHash, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n = (bigInteger.bitLength() + 7) / 8;
        byte[] byArray = SRP6Util.getPadded(bigInteger2, n);
        byte[] byArray2 = SRP6Util.getPadded(bigInteger3, n);
        tlsHash.update(byArray, 0, byArray.length);
        tlsHash.update(byArray2, 0, byArray2.length);
        return new BigInteger(1, tlsHash.calculateHash());
    }

    private static byte[] getPadded(BigInteger bigInteger, int n) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((BigInteger)bigInteger);
        if (byArray.length < n) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
            byArray = byArray2;
        }
        return byArray;
    }
}

