/*
 * Decompiled with CFR 0.152.
 */
package hughai.packcoordinators;

import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import hughai.CSAI;
import hughai.GiveOrderWrapper;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.mapping.LosHelper;
import hughai.mapping.Maps;
import hughai.packcoordinators.IPackCoordinator;
import hughai.utils.DrawingUtils;
import hughai.utils.LogFile;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;

public abstract class PackCoordinator
implements IPackCoordinator {
    Collection<Unit> unitsControlled = new HashSet<Unit>();
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;
    DrawingUtils drawingUtils;
    GiveOrderWrapper giveOrderWrapper;
    Maps maps;
    LosHelper losHelper;
    Random random = new Random();
    String packcoordinatorname = "";
    boolean debugon = false;
    boolean activated = false;
    boolean restartedfrompause = true;

    public PackCoordinator(PlayerObjects playerObjects) {
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.drawingUtils = playerObjects.getDrawingUtils();
        this.giveOrderWrapper = playerObjects.getGiveOrderWrapper();
        this.maps = playerObjects.getMaps();
        this.losHelper = playerObjects.getLosHelper();
        this.packcoordinatorname = this.getClass().getSimpleName();
        this.debugon = this.csai.DebugOn;
        this.csai.RegisterVoiceCommand("dumppacks", new DumpPacks());
        this.logfile.WriteLine(this.getClass().getSimpleName() + " initialized.");
    }

    abstract void Recoordinate();

    @Override
    public void Activate() {
        if (!this.activated) {
            this.logfile.WriteLine(this.packcoordinatorname + " activating");
            this.activated = true;
            this.restartedfrompause = true;
            this.Recoordinate();
        }
    }

    @Override
    public void Disactivate() {
        this.logfile.WriteLine(this.packcoordinatorname + " deactivating");
        this.activated = false;
    }

    @Override
    public void AssignUnits(Collection<Unit> collection) {
        for (Unit unit : collection) {
            this.unitsControlled.add(unit);
            this.logfile.WriteLine("New " + this.packcoordinatorname + " unit: " + unit.getUnitId() + " " + unit.getDef().getHumanName());
        }
        this.Recoordinate();
    }

    @Override
    public void RevokeUnits(Collection<Unit> collection) {
        for (Unit unit : collection) {
            this.unitsControlled.remove(unit);
        }
    }

    class DumpPacks
    implements VoiceCommandHandler {
        DumpPacks() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            if (PackCoordinator.this.unitsControlled.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(PackCoordinator.this.packcoordinatorname + ": size: " + PackCoordinator.this.unitsControlled.size() + " activated: " + PackCoordinator.this.activated + " units: ");
                for (Unit unit : PackCoordinator.this.unitsControlled) {
                    stringBuilder.append(unit.getUnitId() + ":" + unit.getDef().getHumanName() + " ");
                }
                PackCoordinator.this.logfile.WriteLine("" + stringBuilder);
            }
        }
    }
}

