/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.circuitbreaker;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Locale;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.circuitbreaker.AveragingMetricProvider;
import org.apache.solr.util.circuitbreaker.CircuitBreaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCircuitBreaker
extends CircuitBreaker {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
    private static RefCounted<AveragingMetricProvider> averagingMetricProvider;
    private long heapMemoryThreshold;
    private static final ThreadLocal<Long> seenMemory;
    private static final ThreadLocal<Long> allowedMemory;

    public MemoryCircuitBreaker() {
        this(6, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemoryCircuitBreaker(int numSamples, int sampleInterval) {
        Class<MemoryCircuitBreaker> clazz = MemoryCircuitBreaker.class;
        synchronized (MemoryCircuitBreaker.class) {
            if (averagingMetricProvider == null || averagingMetricProvider.getRefcount() == 0) {
                averagingMetricProvider = new RefCounted<AveragingMetricProvider>(new AveragingMetricProvider(() -> MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed(), numSamples, sampleInterval)){

                    @Override
                    protected void close() {
                        ((AveragingMetricProvider)this.get()).close();
                    }
                };
            }
            averagingMetricProvider.incref();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public MemoryCircuitBreaker setThreshold(double thresholdValueInPercentage) {
        long currentMaxHeap = MEMORY_MX_BEAN.getHeapMemoryUsage().getMax();
        if (currentMaxHeap <= 0L) {
            throw new IllegalArgumentException("Invalid JVM state for the max heap usage");
        }
        double thresholdInFraction = thresholdValueInPercentage / 100.0;
        this.heapMemoryThreshold = (long)((double)currentMaxHeap * thresholdInFraction);
        if (this.heapMemoryThreshold <= 0L) {
            throw new IllegalStateException("Memory limit cannot be less than or equal to zero");
        }
        return this;
    }

    @Override
    public boolean isTripped() {
        long localAllowedMemory = this.getCurrentMemoryThreshold();
        long localSeenMemory = this.getAvgMemoryUsage();
        allowedMemory.set(localAllowedMemory);
        seenMemory.set(localSeenMemory);
        return localSeenMemory >= localAllowedMemory;
    }

    protected long getAvgMemoryUsage() {
        return (long)averagingMetricProvider.get().getMetricValue();
    }

    @Override
    public String getErrorMessage() {
        return "Memory Circuit Breaker triggered as JVM heap usage values are greater than allocated threshold. Seen JVM heap memory usage " + String.valueOf(seenMemory.get()) + " and allocated threshold " + String.valueOf(allowedMemory.get());
    }

    private long getCurrentMemoryThreshold() {
        return this.heapMemoryThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Class<MemoryCircuitBreaker> clazz = MemoryCircuitBreaker.class;
        synchronized (MemoryCircuitBreaker.class) {
            if (averagingMetricProvider != null && averagingMetricProvider.getRefcount() > 0) {
                averagingMetricProvider.decref();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s(threshold=%d, warnOnly=%b)", this.getClass().getSimpleName(), this.heapMemoryThreshold, this.isWarnOnly());
    }

    static {
        seenMemory = ThreadLocal.withInitial(() -> 0L);
        allowedMemory = ThreadLocal.withInitial(() -> 0L);
    }
}

