/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.solr.common.MapWriterMap;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;

public interface NavigableObject {
    default public Object _get(String path) {
        Object v = Utils.getObjectByPath((Object)this, false, path);
        return v;
    }

    @Deprecated
    default public Object _get(String path, Object def) {
        Object v = this._get(path);
        return v == null ? def : v;
    }

    default public String _getStr(String path) {
        Object v = Utils.getObjectByPath((Object)this, false, path);
        if (v == null) {
            return null;
        }
        return String.valueOf(v);
    }

    @Deprecated
    default public String _getStr(String path, String def) {
        String v = this._getStr(path);
        return v == null ? def : v;
    }

    default public void _forEachEntry(String path, BiConsumer fun) {
        Utils.forEachMapEntry((Object)this, path, fun);
    }

    default public void _forEachEntry(List<String> path, BiConsumer fun) {
        Utils.forEachMapEntry((Object)this, path, fun);
    }

    default public void _forEachEntry(BiConsumer fun) {
        Utils.forEachMapEntry(this, fun);
    }

    default public Object _get(List<String> path, Object def) {
        Object v = Utils.getObjectByPath((Object)this, false, path);
        return v == null ? def : v;
    }

    default public String _getStr(List<String> path, String def) {
        Object v = Utils.getObjectByPath((Object)this, false, path);
        return v == null ? def : String.valueOf(v);
    }

    default public int _size() {
        int[] size = new int[1];
        this._forEachEntry((k, v) -> {
            size[0] = size[0] + 1;
        });
        return size[0];
    }

    public static NavigableObject wrap(Object obj) {
        if (obj == null) {
            return SimpleOrderedMap.of();
        }
        if (obj instanceof NavigableObject) {
            return (NavigableObject)obj;
        }
        if (obj instanceof Map) {
            return new MapWriterMap((Map)obj);
        }
        throw new IllegalArgumentException("Cannot wrap " + String.valueOf(obj.getClass()));
    }
}

