/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.argument.positional;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNodeGen;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.ArrayBuilder;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@ImportStatic(value={PythonOptions.class})
@GenerateUncached
@GenerateInline(value=false)
public abstract class ExecutePositionalStarargsNode
extends Node {
    public abstract Object[] executeWith(Frame var1, Object var2);

    @Specialization
    static Object[] doObjectArray(Object[] starargs) {
        return starargs;
    }

    @Specialization
    static Object[] doTuple(PTuple starargs, @Bind Node inliningTarget, @Cached.Shared(value="toArray") @Cached SequenceStorageNodes.ToArrayNode toArray) {
        return toArray.execute(inliningTarget, starargs.getSequenceStorage());
    }

    @Specialization
    static Object[] doList(PList starargs, @Bind Node inliningTarget, @Cached.Shared(value="toArray") @Cached SequenceStorageNodes.ToArrayNode toArray) {
        return toArray.execute(inliningTarget, starargs.getSequenceStorage());
    }

    @Specialization
    static Object[] doDict(PDict starargs, @Bind Node inliningTarget, @Cached.Shared(value="doHashingStorage") @Cached ExecutePositionalStarargsDictStorageNode node) {
        return node.execute(inliningTarget, starargs.getDictStorage());
    }

    @Specialization
    static Object[] doSet(PSet starargs, @Bind Node inliningTarget, @Cached.Shared(value="doHashingStorage") @Cached ExecutePositionalStarargsDictStorageNode node) {
        return node.execute(inliningTarget, starargs.getDictStorage());
    }

    @Specialization
    static Object[] doNone(PNone none, @Bind Node inliningTarget) {
        throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ARG_AFTER_MUST_BE_ITERABLE, none);
    }

    @Specialization
    static Object[] starargs(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached PRaiseNode raise, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode nextNode) {
        Object iterator = getIter.execute((Frame)frame, inliningTarget, object);
        if (iterator != PNone.NO_VALUE && iterator != PNone.NONE) {
            ArrayBuilder<Object> internalStorage = new ArrayBuilder<Object>();
            try {
                while (true) {
                    Object next = nextNode.execute((Frame)frame, inliningTarget, iterator);
                    internalStorage.add(next);
                }
            }
            catch (IteratorExhausted e) {
                return internalStorage.toArray(new Object[0]);
            }
        }
        throw raise.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ARG_AFTER_MUST_BE_ITERABLE, object);
    }

    @NeverDefault
    public static ExecutePositionalStarargsNode create() {
        return ExecutePositionalStarargsNodeGen.create();
    }

    public static ExecutePositionalStarargsNode getUncached() {
        return ExecutePositionalStarargsNodeGen.getUncached();
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ExecutePositionalStarargsDictStorageNode
    extends Node {
        ExecutePositionalStarargsDictStorageNode() {
        }

        abstract Object[] execute(Node var1, HashingStorage var2);

        @Specialization
        static Object[] doIt(Node inliningTarget, HashingStorage storage, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetIterator getIter, @Cached HashingStorageNodes.HashingStorageIteratorNext iterNext, @Cached HashingStorageNodes.HashingStorageIteratorKey iteratorKey) {
            int length = lenNode.execute(inliningTarget, storage);
            Object[] args = new Object[length];
            HashingStorageNodes.HashingStorageIterator it = getIter.execute(inliningTarget, storage);
            for (int i = 0; i < args.length; ++i) {
                boolean hasNext = iterNext.execute(inliningTarget, storage, it);
                assert (hasNext);
                args[i] = iteratorKey.execute(inliningTarget, storage, it);
            }
            return args;
        }
    }
}

