/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.stubs.elements.KtPlaceHolderStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtValueArgumentListElementType
extends KtPlaceHolderStubElementType<KtValueArgumentList> {
    public KtValueArgumentListElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            KtValueArgumentListElementType.$$$reportNull$$$0(0);
        }
        super(debugName, KtValueArgumentList.class);
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        ASTNode treeParent = node.getTreeParent();
        if (treeParent == null) {
            return false;
        }
        IElementType callType = treeParent.getElementType();
        if (KtValueArgumentListElementType.shouldSkipStubCreation(node, callType)) {
            return false;
        }
        return super.shouldCreateStub(node);
    }

    private static boolean shouldSkipStubCreation(ASTNode listNode, IElementType callType) {
        if (callType == KtStubElementTypes.ANNOTATION_ENTRY) {
            KtValueArgumentList psi = listNode.getPsi(KtValueArgumentList.class);
            return psi.getArguments().isEmpty();
        }
        return callType != KtStubElementTypes.CALL_EXPRESSION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/psi/stubs/elements/KtValueArgumentListElementType", "<init>"));
    }
}

