/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import org.hibernate.Internal;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.id.table", description="Logging related to table-based identifier generation")
@Internal
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=90101, max=90200)
public interface TableGeneratorLogger
extends BasicLogger {
    public static final String NAME = "org.hibernate.orm.id.table";
    public static final Logger TABLE_GENERATOR_LOGGER = Logger.getLogger((String)"org.hibernate.orm.id.table");
    public static final TableGeneratorLogger TABLE_GENERATOR_MESSAGE_LOGGER = (TableGeneratorLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), TableGeneratorLogger.class, (String)"org.hibernate.orm.id.table");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not read hi value in table: %s", id=90101)
    public void unableToReadHiValue(String var1, @Cause SQLException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not read or initialize hi value in table: %s", id=90102)
    public void unableToReadOrInitializeHiValue(String var1, @Cause SQLException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not update hi value in table: %s", id=90103)
    public void unableToUpdateHiValue(String var1, @Cause SQLException var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Forcing table use for sequence-style generator due to pooled optimizer selection where db does not support pooled sequences", id=90107)
    public void forcingTableUse();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Explicit segment value for id generator [%s.%s] suggested; using default [%s]", id=90110)
    public void usingDefaultIdGeneratorSegmentValue(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Retrieving current value for table generator segment '%s'", id=90111)
    public void retrievingCurrentValueForSegment(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Inserting initial value '%s' for table generator segment '%s'", id=90112)
    public void insertingInitialValueForSegment(Object var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Updating current value to '%s' for table generator segment '%s'", id=90113)
    public void updatingCurrentValueForSegment(Object var1, String var2);
}

