/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.config.internal;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class ConfigurationServiceImpl
implements ConfigurationService,
ServiceRegistryAwareService {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)ConfigurationServiceImpl.class.getName());
    private final Map<String, Object> settings;
    private ServiceRegistryImplementor serviceRegistry;

    public ConfigurationServiceImpl(Map<String, Object> settings) {
        this.settings = Collections.unmodifiableMap(settings);
    }

    @Override
    public Map<String, Object> getSettings() {
        return this.settings;
    }

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public <T> @Nullable T getSetting(String name, ConfigurationService.Converter<T> converter) {
        return this.getSetting(name, converter, null);
    }

    @Override
    public <T> @PolyNull T getSetting(String name, ConfigurationService.Converter<T> converter, @PolyNull T defaultValue) {
        Object value = this.settings.get(name);
        if (value == null) {
            return defaultValue;
        }
        return converter.convert(value);
    }

    @Override
    public <T> @PolyNull T getSetting(String name, Class<T> expected, @PolyNull T defaultValue) {
        Object value = this.settings.get(name);
        T target = this.cast(expected, value);
        return target != null ? target : defaultValue;
    }

    public <T> @Nullable T cast(Class<T> expected, @Nullable Object candidate) {
        Class target;
        if (candidate == null) {
            return null;
        }
        if (expected.isInstance(candidate)) {
            return (T)candidate;
        }
        if (candidate instanceof Class) {
            target = (Class)candidate;
        } else {
            try {
                target = this.serviceRegistry.requireService(ClassLoaderService.class).classForName(candidate.toString());
            }
            catch (ClassLoadingException e) {
                LOG.debugf("Unable to locate %s implementation class %s", expected.getName(), candidate.toString());
                target = null;
            }
        }
        if (target != null) {
            try {
                return target.newInstance();
            }
            catch (Exception e) {
                LOG.debugf("Unable to instantiate %s class %s", expected.getName(), target.getName());
            }
        }
        return null;
    }
}

