/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;

public class DefaultFileHasher
implements FileHasher {
    private final StreamHasher streamHasher;

    public DefaultFileHasher(StreamHasher streamHasher) {
        this.streamHasher = streamHasher;
    }

    @Override
    public HashCode hash(File file) {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(String.format("Failed to create MD5 hash for file '%s' as it does not exist.", file), e);
        }
        try {
            HashCode e = this.streamHasher.hash(inputStream);
            return e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create MD5 hash for file '%s'", file), e);
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public HashCode hash(File file, long length, long lastModified) {
        return this.hash(file);
    }
}

