/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.DBRuntimeException;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public interface DBDDataReceiver
extends AutoCloseable {
    public void fetchStart(@NotNull DBCSession var1, @NotNull DBCResultSet var2, long var3, long var5) throws DBException;

    public void fetchRow(@NotNull DBCSession var1, @NotNull DBCResultSet var2) throws DBException;

    public void fetchEnd(@NotNull DBCSession var1, @NotNull DBCResultSet var2) throws DBException;

    @Override
    public void close();

    @NotNull
    default public DBCStatistics getStatistics() {
        return new DBCStatistics();
    }

    public static void startFetchWorkflow(@NotNull DBDDataReceiver dataReceiver, @NotNull DBCSession session, @NotNull DBCResultSet resultSet, long offset, long maxRows) throws DBException {
        dataReceiver.fetchStart(session, resultSet, offset, maxRows);
        resultSet.getSourceStatement().autoCloseDependant(() -> {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    try {
                        dataReceiver.fetchEnd(session, resultSet);
                    }
                    finally {
                        if (dataReceiver != null) {
                            dataReceiver.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (DBCException e) {
                throw new DBRuntimeException("Error while finishing result set fetching into " + String.valueOf(dataReceiver), e);
            }
        });
    }

    public static void fetchRowsWithStatistics(@NotNull DBDDataReceiver dataReceiver, @NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBCStatistics statistics) throws DBException {
        DBRProgressMonitor progressMonitor = session.getProgressMonitor();
        DBFetchProgress fetchProgress = new DBFetchProgress(progressMonitor);
        while (!progressMonitor.isCanceled() && resultSet.nextRow()) {
            dataReceiver.fetchRow(session, resultSet);
            fetchProgress.monitorRowFetch();
        }
        fetchProgress.dumpStatistics(statistics);
    }
}

