/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.javagnome.Handle;

/**
 * The MenuBar is a subclass of MenuShell which contains one to many
 * MenuItem.  The result is a standard menu bar which can hold many
 * menu items.  MenuBar allows for a shadow type to be set for aesthetic
 * purposes.
 */
public class MenuBar extends MenuShell {

	/**
	 * Creates a new menubar from a handle to internal resources. This should
	 * only be used internally by Java-Gnome.
	 */
	public MenuBar(Handle handle){
	    super(handle);
	}

	/**
	 * Create a new MenuBar.
	 */
	public MenuBar() {
		super(gtk_menu_bar_new());
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_menu_bar_get_type());
	}
	
	/**
	 * 
	 */
	public PackDirection getPackDirection() {
		return PackDirection.intern(gtk_menu_bar_get_pack_direction(getHandle()));
	}

	/**
	 * 
	 * @param packDirection
	 */
	public void setPackDirection(PackDirection packDirection) {
		gtk_menu_bar_set_pack_direction(getHandle(), packDirection.getValue());
	}

	/**
	 * 
	 */
	public PackDirection getChildPackDirection() {
		return PackDirection.intern(gtk_menu_bar_get_child_pack_direction(getHandle()));
	}

	public void setChildPackDirection(PackDirection packDirection) {
		gtk_menu_bar_set_child_pack_direction(getHandle(), packDirection.getValue());
	}
	
	native static final protected int gtk_menu_bar_get_type();
	native static final protected Handle gtk_menu_bar_new();
	// new in gtk 2.8
	native static final protected int gtk_menu_bar_get_pack_direction(Handle mb);
	native static final protected void gtk_menu_bar_set_pack_direction(Handle mb, int pack);
	native static final protected int gtk_menu_bar_get_child_pack_direction(Handle mb);
	native static final protected void gtk_menu_bar_set_child_pack_direction(Handle mb, int pack);

}
