/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Type;
import org.gnu.javagnome.Handle;

/**
 * A CellRenderer is an object used to reder data in a {@link TreeView} widget.
 * This is for all types of Table, Tree and list. Each renderer has one or more
 * {@link CellRendererAttribute}. These attributes are for data to be rendered.
 * This data is usually stored in a {@link TreeModel} object; the two current
 * implementations of {@link TreeModel} being {@link ListStore} (for tables and
 * lists) and {@link TreeStore} for trees. 
 * <p>The choice of data to be rendered is particular to the TreeView widget -
 * any number of TreeView widgets may share the same data and choose to display
 * only a selection of it. Data is displayed in a {@link TreeView} widget by
 * attaching {@link TreeViewColumn}s and packing any number of {@link
 * CellRenderer}s into each column. Links are then made between the renderers
 * and the data in the model via the {@link
 * TreeViewColumn#addAttributeMapping(CellRenderer, CellRendererAttribute, DataColumn)}
 * method. 
 *
 * <p>This class is a base class for the renderers, either home grown or any of
 * the following standard renderers:
 * <ul>
 * <li>{@link CellRendererPixbuf}
 * <li>{@link CellRendererText}
 * <li>{@link CellRendererToggle}
 * </ul>
 *
 * <p>For a full overview of the tree and list objects, see the {@link TreeView}
 * description.
 */
public class CellRenderer extends GtkObject 
{
	CellRenderer(Handle hndl) {
		super(hndl);
	}
    
    static CellRenderer getCellRenderer(Handle handle) {
        if (handle == null)
            return null;
        
        CellRenderer obj = (CellRenderer) GObject.getGObjectFromHandle(handle);
        
        if (obj == null)
            obj = new CellRenderer(handle);
        
        return obj;
    }
	
	/**
	 * fixme:
	 * to allow users to create cellrenderers, something will have to be done
	 * here.
	 * Anyone interested?
	 */

	/*
	 * FIXME: There are a number of properties which cellrenderers can have. We
	 * don't support setting/getting any of them at the moment:
	 *
	 *  "cell-background"      gchararray           : Write
  "cell-background-gdk"  GdkColor             : Read / Write
  "cell-background-set"  gboolean             : Read / Write
  "height"               gint                 : Read / Write
  "is-expanded"          gboolean             : Read / Write
  "is-expander"          gboolean             : Read / Write
  "mode"                 GtkCellRendererMode  : Read / Write
  "visible"              gboolean             : Read / Write
  "width"                gint                 : Read / Write
  "xalign"               gfloat               : Read / Write
  "xpad"                 guint                : Read / Write
  "yalign"               gfloat               : Read / Write
  "ypad"                 guint                : Read / Write
  */
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_cell_renderer_get_type());
	}
	

    native static final protected int gtk_cell_renderer_get_type ();
    native static final protected void gtk_cell_renderer_get_size (Handle cell, Handle widget, Handle cellArea, int [] xOffset, int [] yOffset, int [] width, int [] height);
    native static final protected void gtk_cell_renderer_render (Handle cell, Handle window, Handle widget, Handle backgroundArea, Handle cellArea, Handle exposedArea, int flags);
    native static final protected boolean gtk_cell_renderer_activate (Handle cell, Handle event, Handle widget, String path, Handle backgroundArea, Handle cellArea, int flags);
    native static final protected int gtk_cell_renderer_start_editing (Handle cell, Handle event, Handle widget, String path, Handle backgroundArea, Handle cellArea, int flags);
    native static final protected void gtk_cell_renderer_set_fixed_size (Handle cell, int width, int height);
    native static final protected void gtk_cell_renderer_get_fixed_size (Handle cell, int [] width, int [] height);
    native static final protected void gtk_cell_renderer_stop_editing(Handle cell, boolean canceled);

    /* Deprecated method.
    native static final private void gtk_cell_renderer_editing_canceled(Handle cell);
    */
}

