/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import org.gnu.glib.Type;
import org.gnu.javagnome.Handle;

/**
 * A Pixmap is an offscreen drawable.  It can be drawn upon with
 * the standard drawing primitives, then copied to another Drawable.
 */
public class Pixmap extends Drawable 
{
    public Pixmap(Drawable drawable, int width, int height, int depth) {
        super(gdk_pixmap_new(drawable.getHandle(), width, height, depth));
    }
	
    public Pixmap(Drawable drawable, byte[] data, int width, int height, int depth, Color fg, Color bg) {
        super(gdk_pixmap_create_from_data(drawable.getHandle(), data, width, height, depth, fg.getHandle(), bg.getHandle()));
    }
	
    public Pixmap(Drawable drawable, Bitmap mask, Color transparent, String filename) {
        super(gdk_pixmap_create_from_xpm(drawable.getHandle(), mask.getHandle(), transparent.getHandle(), filename));
    }

    public Pixmap(Drawable drawable, Colormap colormap, Bitmap mask, Color transparent, String filename) {
        super(gdk_pixmap_colormap_create_from_xpm(drawable.getHandle(), colormap.getHandle(), mask.getHandle(), transparent.getHandle(), filename));
        
    }

    public Pixmap(Drawable drawable, Bitmap mask, Color transparent, byte[] data) {
        super(gdk_pixmap_create_from_xpm_d(drawable.getHandle(), mask.getHandle(), transparent.getHandle(), data));
    }

    public Pixmap(Drawable drawable, Colormap colormap, Bitmap mask, Color transparent, byte[] data) {
        super(gdk_pixmap_colormap_create_from_xpm_d(drawable.getHandle(), colormap.getHandle(), mask.getHandle(), transparent.getHandle(), data));
    }

    /**
     * Construct a new Pixmap from a handle to a native resource.
     * @param handle The handle to the native resource.
     */
    Pixmap(Handle handle){
        super(handle);
    }
	
    /**
     * Retrieve the runtime type used by the GLib library.
     */
    public static Type getType() {
        return new Type(gdk_pixmap_get_type());
    }
	

    native static final protected int gdk_pixmap_get_type ();
    native static final protected Handle gdk_pixmap_new (Handle window, int width, int height, int depth);
    native static final protected Handle gdk_pixmap_create_from_data (Handle window, byte[] data, int  width, int height, int depth, Handle fg, Handle bg);
    native static final protected Handle gdk_pixmap_create_from_xpm (Handle window, Handle mask, Handle transparentColor, String filename);

    native static final protected Handle gdk_pixmap_colormap_create_from_xpm (Handle window, Handle colormap, Handle mask, Handle transparentColor, String filename);
    native static final protected Handle gdk_pixmap_create_from_xpm_d (Handle window, Handle mask, Handle transparentColor, byte[] data);
    native static final protected Handle gdk_pixmap_colormap_create_from_xpm_d (Handle window, Handle colormap, Handle mask, Handle transparentColor, byte[] data);
    //    native static final protected int gdk_pixmap_foreign_new (Handle anid);

}

