/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

 /*
  * TODO:
  *	Some methods look ugly and unusable. Are they going to be implemented? 
  *	
  * 
  */
 
package org.gnu.gdk;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
/**
 * This object stores the mapping between the color values stored
 * in memory and the RGB values that are used to display color values.	
 */
public class Colormap extends GObject 
{
	
	/**
	 * Create a Colormap initialized to the system's
	 * default colormap.
	 */
	public Colormap() {
		super(Colormap.gdk_colormap_get_system());
	}
	
	/**
	 * Create a new Colormap from a handle to a native resource.
	 */
	public Colormap(Handle handle){
		super(handle);
	}
	
	/**
	*	Creates a new colormap for the given visual.
	*	
	*/
	public Colormap(org.gnu.gdk.Visual v, boolean allocate){
		super(gdk_colormap_new(v.getHandle(), allocate));
	} 
	
	/**
	*	Returns the system's default colormap.
	*/
	public static Colormap getSystem(){
		return new Colormap(Colormap.gdk_colormap_get_system());
	}
	
	/**
	*	Returns the visual for which the colormap was created.
	*/
	public Visual getVisual(){
	    Handle hndl = gdk_colormap_get_visual(getHandle());
		GObject obj = getGObjectFromHandle(hndl);
		if (null != obj)
			return (Visual)obj;
		return new Visual(hndl);
	}
	
	/**
	 * Returns the screen for which the colormap was created.
	 * @return
	 */
	public Screen getScreen() {
	    Handle hndl = gdk_colormap_get_screen(getHandle());
		GObject obj = getGObjectFromHandle(hndl);
		if (null != obj)
			return (Screen)obj;
		return new Screen(hndl);
	}
	
	/**
	 * Allocates a single color from a colormap.
	 * 
	 * @param color The color to allocate
	 * @param writable If true the color is allocated writable.
	 * @param bestMatch If true GDK will attempt to do matching against existing
	 * colors if the color cannot be allocated as requested.
	 */
	public boolean allocateColor(Color color, boolean writable, boolean bestMatch) {
		return Colormap.gdk_colormap_alloc_color(getHandle(), color.getHandle(), writable, bestMatch);
	}

	/**
	 * Allocates colors from a colormap.
	 * @param colors
	 * @param writable
	 * @param bestMatch
	 * @return
	 */
	public boolean[] allocateColors(Color[] colors, boolean writable, boolean bestMatch) {
		Handle[] hndls = new Handle[colors.length];
		for (int i = 0; i < colors.length; i++)
			hndls[i] = colors[i].getHandle();
		boolean[] success = new boolean[colors.length];
		gdk_colormap_alloc_colors(getHandle(), hndls, writable, bestMatch, success);
		return success;
	}

	/**
	 * Frees previously allocated Colors.
	 * @param colors
	 */
	public void freeColors(Color[] colors) {
		Handle[] hndls = new Handle[colors.length];
		for (int i = 0; i < colors.length; i++)
			hndls[i] = colors[i].getHandle();
		gdk_colormap_free_colors(getHandle(), hndls);
	}
	
	/**
	 * Locates the RGB color corresponding to the given hardware
	 * pixel.  The pixel must be a valid pixel in the colormap.
	 * @param pixel
	 * @return
	 */
	public Color queryColor(long pixel) {
		Handle hndl = GObject.getNullHandle();
		gdk_colormap_query_color(getHandle(), pixel, hndl);
		return new Color(hndl);
	}

    native static final protected int gdk_colormap_get_type ();
    native static final protected Handle gdk_colormap_new (Handle visual, boolean allocate);
    native static final protected Handle gdk_colormap_get_system ();
    native static final protected int gdk_colormap_alloc_colors (Handle colormap, Handle[] colors, 
        boolean writable, boolean bestMatch, boolean[] success);
    native static final protected boolean gdk_colormap_alloc_color (Handle colormap, Handle color, 
        boolean writable, boolean best_match);
    native static final protected void gdk_colormap_free_colors (Handle colormap, Handle[] colors);
    native static final protected void gdk_colormap_query_color (Handle colormap, long pixel, Handle result);
    native static final protected Handle gdk_colormap_get_visual (Handle colormap);
    native static final protected Handle gdk_colormap_get_screen(Handle colormap);
}

