/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>

#ifndef _Included_org_gnu_gdk_Display
#define _Included_org_gnu_gdk_Display
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gdk_display_get_type();
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_open
 * Signature: (Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Display_gdk_1display_1open
  (JNIEnv *env, jclass cls, jstring name)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	jint dis = (jint)gdk_display_open(n);
	(*env)->ReleaseStringUTFChars(env, name, n);
	return dis;
}


/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_name
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1name
  (JNIEnv *env, jclass cls, jint display)
{
	const gchar* name = gdk_display_get_name((GdkDisplay*)display);
	return (*env)->NewStringUTF(env, name);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_n_screens
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1n_1screens
  (JNIEnv *env, jclass cls, jint display)
{
	return (jint)gdk_display_get_n_screens((GdkDisplay*)display);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_screen
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1screen
  (JNIEnv *env, jclass cls, jint display, jint screenNum)
{
	return (jint)gdk_display_get_screen((GdkDisplay*)display, screenNum);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_default_screen
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1default_1screen
  (JNIEnv *env, jclass cls, jint display)
{
	return (jint)gdk_display_get_default_screen((GdkDisplay*)display);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_pointer_ungrab
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1pointer_1ungrab
  (JNIEnv *env, jclass cls, jint display, jint time)
{
	gdk_display_pointer_ungrab((GdkDisplay*)display, (guint32)time);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_keyboard_ungrab
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1keyboard_1ungrab
  (JNIEnv *env, jclass cls, jint display, jint time)
{
	gdk_display_keyboard_ungrab((GdkDisplay*)display, (guint32)time);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_pointer_is_grabbed
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Display_gdk_1display_1pointer_1is_1grabbed
  (JNIEnv *env, jclass cls, jint display)
{
	return (jboolean)gdk_display_pointer_is_grabbed((GdkDisplay*)display);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_beep
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1beep
  (JNIEnv *env, jclass cls, jint display)
{
	gdk_display_beep((GdkDisplay*)display);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_sync
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1sync
  (JNIEnv *env, jclass cls, jint display)
{
	gdk_display_sync((GdkDisplay*)display);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_flush
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1flush
  (JNIEnv *env, jclass cls, jint display)
{
	gdk_display_flush((GdkDisplay*)display);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_close
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1close
  (JNIEnv *env, jclass cls, jint display)
{
	gdk_display_close((GdkDisplay*)display);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_list_devices
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gdk_Display_gdk_1display_1list_1devices
  (JNIEnv *env, jclass cls, jint display)
{
	GList* list;
	GList* item;
	jintArray array;
	guint len;
	guint index;
	
	list = gdk_display_list_devices((GdkDisplay*)display);
	if (NULL == list)
		return NULL;
	len = g_list_length(list);
	array = (*env)->NewIntArray(env, len);
	for (index = 0; index < len; index++) {
		item = g_list_nth(list, index);
		(*env)->SetIntArrayRegion(env, array, index, len, (jint*)(GdkDevice*)item->data);
	}
	return array;
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_event
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1event
  (JNIEnv *env, jclass cls, jint display)
{
	return (jint)gdk_display_get_event((GdkDisplay*)display);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_peek_event
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Display_gdk_1display_1peek_1event
  (JNIEnv *env, jclass cls, jint display)
{
	return (jint)gdk_display_peek_event((GdkDisplay*)display);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_put_event
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1put_1event
  (JNIEnv *env, jclass cls, jint display, jint event)
{
	gdk_display_put_event((GdkDisplay*)display, (GdkEvent*)event);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_default
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1default
  (JNIEnv *env,  jclass cls)
{
	return (jint)gdk_display_get_default();
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_core_pointer
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1core_1pointer
  (JNIEnv *env, jclass cls, jint display)
{
	return (jint)gdk_display_get_core_pointer((GdkDisplay*)display);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_pointer
 * Signature: (I[I[I[I[I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1pointer
  (JNIEnv *env, jclass cls, jint display, jintArray screen, jintArray xVal, jintArray yVal, jintArray mask)
{
	GdkScreen* scr = (GdkScreen*)(*env)->GetIntArrayElements(env, screen, NULL);
	int* x = (int*)(*env)->GetIntArrayElements(env, xVal, NULL);
	int* y = (int*)(*env)->GetIntArrayElements(env, yVal, NULL);
	GdkModifierType* mod = (GdkModifierType*)(*env)->GetIntArrayElements(env, mask, NULL);
	gdk_display_get_pointer((GdkDisplay*)display, &scr, x, y, mod);
	(*env)->ReleaseIntArrayElements(env, screen, (jint*)scr, 0);
	(*env)->ReleaseIntArrayElements(env, xVal, (jint*)x, 0);
	(*env)->ReleaseIntArrayElements(env, yVal, (jint*)y, 0);
	(*env)->ReleaseIntArrayElements(env, mask, (jint*)mod, 0);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_window_at_pointer
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1window_1at_1pointer
  (JNIEnv *env, jclass cls, jint display, jint x, jint y)
{
	return (jint)gdk_display_get_window_at_pointer((GdkDisplay*)display, (gint *)&x, (gint *)&y);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_supports_cursor_alpha
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Display_gdk_1display_1supports_1cursor_1alpha
  (JNIEnv *env, jclass cls, jint display)
{
	return (jboolean)gdk_display_supports_cursor_alpha((GdkDisplay*)display);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_supports_cursor_color
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Display_gdk_1display_1supports_1cursor_1color
  (JNIEnv *env, jclass cls, jint display)
{
	return (jboolean)gdk_display_supports_cursor_color((GdkDisplay*)display);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_default_cursor_size
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1default_1cursor_1size
  (JNIEnv *env, jclass cls, jint display)
{
	return (jint)gdk_display_get_default_cursor_size((GdkDisplay*)display);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_maximum_cursor_size
 * Signature: (I[I[I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1maximum_1cursor_1size
  (JNIEnv *env, jclass cls, jint display, jintArray width, jintArray height)
{
	int* w = (int*)(*env)->GetIntArrayElements(env, width, NULL);
	int* h = (int*)(*env)->GetIntArrayElements(env, height, NULL);
	gdk_display_get_maximal_cursor_size((GdkDisplay*)display, w, h);
	(*env)->ReleaseIntArrayElements(env, width, (jint*)w, 0);
	(*env)->ReleaseIntArrayElements(env, height, (jint*)h, 0);
}

#ifdef __cplusplus
}
#endif
#endif
