/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.GraphvizException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ResultHandler.class);
    private final BlockingQueue<String> value = new ArrayBlockingQueue<String>(1);
    private boolean ok;

    public void log(String msg) {
        LOG.warn(msg);
    }

    public void setResult(String result2) {
        this.ok = true;
        this.value.add(result2);
    }

    public void setError(String error) {
        this.ok = false;
        this.value.add(error);
    }

    public String waitFor() {
        try {
            String v = this.value.take();
            if (this.ok) {
                return v;
            }
            throw new GraphvizException(v);
        }
        catch (InterruptedException e) {
            throw new GraphvizException("Waiting for result interrupted", e);
        }
    }
}

