// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2012 Konrad Twardowski

// A system tray and notification area

#pragma once

#ifdef KS_KF5
	#include <KStatusNotifierItem>
#else
	#include <QSystemTrayIcon>
#endif // KS_KF5

class MainWindow;

class USystemTray final: public QObject {
public:
	explicit USystemTray(MainWindow *mainWindow);
	virtual ~USystemTray() = default;
	void info(const QString &message) const;
	bool isSupported() const;
	static QPixmap makeIcon(const QIcon &baseIcon, const int size, const bool custom, const bool active, const QColor &normalColor, const QColor &activeColor);
	void setToolTip(const QString &toolTip);
	void setVisible(const bool visible);
	void updateIcon();
	void warning(const QString &message) const;
private:
	Q_DISABLE_COPY(USystemTray)
	#ifdef KS_KF5
	KStatusNotifierItem *m_trayIcon = nullptr;
	#else
	bool m_applyIconHack = true;
	bool m_sessionRestored;
	QSystemTrayIcon *m_trayIcon = nullptr;
	#endif // KS_KF5
	QString m_toolTip = QString();
	MainWindow *getMainWindow();
};
