/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.model.CalculatedModelValue;
import org.gradle.internal.model.ModelContainer;
import org.gradle.util.Path;

public abstract class StandaloneDomainObjectContext
implements DomainObjectContext,
ModelContainer<Object> {
    private static final Object MODEL = new Object();
    public static final StandaloneDomainObjectContext ANONYMOUS = new StandaloneDomainObjectContext(){

        public String getDisplayName() {
            return "unknown";
        }
    };
    public static final StandaloneDomainObjectContext PLUGINS = new StandaloneDomainObjectContext(){

        @Override
        public boolean isPluginContext() {
            return true;
        }

        public String getDisplayName() {
            return "plugin resolution";
        }
    };

    public static StandaloneDomainObjectContext forScript(final ScriptSource source) {
        return new StandaloneDomainObjectContext(){

            public String getDisplayName() {
                return source.getShortDisplayName().getDisplayName();
            }
        };
    }

    public static StandaloneDomainObjectContext forProjectBuildscript(final ProjectInternal project) {
        return new StandaloneDomainObjectContext(){

            @Override
            public Path getBuildPath() {
                return project.getBuildPath();
            }

            public String getDisplayName() {
                return "buildscript of " + project.getDisplayName();
            }

            @Override
            public boolean isRootScript() {
                return false;
            }
        };
    }

    public static StandaloneDomainObjectContext detachedFrom(final DomainObjectContext owner) {
        return new StandaloneDomainObjectContext(){

            @Override
            public Path getBuildPath() {
                return owner.getBuildPath();
            }

            public String getDisplayName() {
                return "detached context for " + owner.getDisplayName();
            }

            @Override
            public boolean isDetachedState() {
                return true;
            }
        };
    }

    private StandaloneDomainObjectContext() {
    }

    @Override
    public Path identityPath(String name) {
        return Path.path((String)name);
    }

    @Override
    public Path projectPath(String name) {
        return Path.path((String)name);
    }

    @Override
    @Nullable
    public ProjectIdentity getProjectIdentity() {
        return null;
    }

    @Override
    @Nullable
    public ProjectInternal getProject() {
        return null;
    }

    public ModelContainer<Object> getModel() {
        return this;
    }

    public boolean hasMutableState() {
        return true;
    }

    public <S> S fromMutableState(Function<? super Object, ? extends S> factory) {
        return factory.apply(MODEL);
    }

    public <S> S forceAccessToMutableState(Function<? super Object, ? extends S> factory) {
        return factory.apply(MODEL);
    }

    public void applyToMutableState(Consumer<? super Object> action) {
        action.accept(MODEL);
    }

    @Override
    public Path getBuildPath() {
        return Path.ROOT;
    }

    @Override
    public boolean isScript() {
        return true;
    }

    @Override
    public boolean isRootScript() {
        return true;
    }

    @Override
    public boolean isPluginContext() {
        return false;
    }

    public <T> CalculatedModelValue<T> newCalculatedValue(@Nullable T initialValue) {
        return new CalculatedModelValueImpl<T>(initialValue);
    }

    private static class CalculatedModelValueImpl<T>
    implements CalculatedModelValue<T> {
        private volatile T value;

        CalculatedModelValueImpl(@Nullable T initialValue) {
            this.value = initialValue;
        }

        public T get() throws IllegalStateException {
            T currentValue = this.getOrNull();
            if (currentValue == null) {
                throw new IllegalStateException("No value is available.");
            }
            return currentValue;
        }

        public T getOrNull() {
            return this.value;
        }

        public void set(T newValue) {
            this.value = newValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T update(Function<T, T> updateFunction) {
            CalculatedModelValueImpl calculatedModelValueImpl = this;
            synchronized (calculatedModelValueImpl) {
                T newValue = updateFunction.apply(this.value);
                this.value = newValue;
                return newValue;
            }
        }
    }
}

