/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Collections;
import io.vavr.collection.Traversable;
import java.util.NoSuchElementException;

abstract class AbstractQueue<T, Q extends AbstractQueue<T, Q>>
implements Traversable<T> {
    AbstractQueue() {
    }

    public Tuple2<T, Q> dequeue() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("dequeue of empty " + this.getClass().getSimpleName());
        }
        return Tuple.of(this.head(), this.tail());
    }

    public abstract Q tail();

    public Q retainAll(Iterable<? extends T> elements) {
        return (Q)Collections.retainAll(this, elements);
    }

    public Q removeAll(Iterable<? extends T> elements) {
        return (Q)Collections.removeAll(this, elements);
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }
}

