/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.InstallArtifactRefreshHandler;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironmentFactory;
import org.eclipse.virgo.kernel.install.pipeline.Pipeline;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyBundleDependenciesException;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.util.common.GraphNode;

final class StandardInstallArtifactRefreshHandler
implements InstallArtifactRefreshHandler {
    private final InstallEnvironmentFactory installEnvironmentFactory;
    private final Pipeline refreshPipeline;

    StandardInstallArtifactRefreshHandler(InstallEnvironmentFactory installEnvironmentFactory, Pipeline refreshPipeline) {
        this.installEnvironmentFactory = installEnvironmentFactory;
        this.refreshPipeline = refreshPipeline;
    }

    @Override
    public boolean refresh(InstallArtifact installArtifact) {
        GraphNode<InstallArtifact> graph = installArtifact.getGraph();
        boolean refreshed = true;
        InstallEnvironment installEnvironment = this.installEnvironmentFactory.createInstallEnvironment(installArtifact);
        try {
            try {
                this.refreshPipeline.process(graph, installEnvironment);
            }
            catch (UnableToSatisfyBundleDependenciesException unableToSatisfyBundleDependenciesException) {
                refreshed = false;
                installEnvironment.destroy();
            }
            catch (DeploymentException deploymentException) {
                refreshed = false;
                installEnvironment.destroy();
            }
        }
        finally {
            installEnvironment.destroy();
        }
        return refreshed;
    }
}

