/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.template;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonValue;

class Position {
    final float percentage;
    final int offset;

    Position(float percentage, int offset) {
        this.percentage = percentage;
        this.offset = offset;
    }

    JsonValue toJson() {
        if (this.percentage == 0.0f) {
            return JsonValue.valueOf(this.offset);
        }
        return new JsonArray().add(this.percentage).add(this.offset);
    }

    public String toString() {
        return "Position{ " + this.percentage + "%, " + this.offset + "px }";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Position) {
            Position other = (Position)object;
            return other.offset == this.offset && Float.floatToIntBits(other.percentage) == Float.floatToIntBits(this.percentage);
        }
        return false;
    }

    public int hashCode() {
        return this.offset ^ Float.floatToIntBits(this.percentage);
    }
}

