/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.dynamic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.dynamic.DynamicClassWriter;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.sessions.Session;

public class DynamicClassLoader
extends ClassLoader {
    protected Map<String, DynamicClassWriter> classWriters = new HashMap<String, DynamicClassWriter>();
    protected Map<String, EnumInfo> enumInfoRegistry = new HashMap<String, EnumInfo>();
    public DynamicClassWriter defaultWriter = new DynamicClassWriter();

    public DynamicClassLoader(ClassLoader delegate) {
        super(delegate);
    }

    public DynamicClassLoader(ClassLoader delegate, DynamicClassWriter writer) {
        this(delegate);
        this.defaultWriter = writer;
    }

    public DynamicClassWriter getDefaultWriter() {
        return this.defaultWriter;
    }

    protected Map<String, DynamicClassWriter> getClassWriters() {
        return this.classWriters;
    }

    public DynamicClassWriter getClassWriter(String className) {
        return this.getClassWriters().get(className);
    }

    public void addEnum(String className, Object ... literalLabels) {
        EnumInfo enumInfo = this.enumInfoRegistry.get(className);
        if (enumInfo == null) {
            enumInfo = new EnumInfo(className);
            this.enumInfoRegistry.put(className, enumInfo);
        }
        if (literalLabels != null) {
            Object[] objectArray = literalLabels;
            int n = literalLabels.length;
            int n2 = 0;
            while (n2 < n) {
                Object literalLabel = objectArray[n2];
                if (literalLabel != null) {
                    enumInfo.addLiteralLabel(literalLabel.toString());
                }
                ++n2;
            }
        }
        this.addClass(className);
    }

    public void addClass(String className) {
        this.addClass(className, this.getDefaultWriter());
    }

    public void addClass(String className, Class<?> parentClass) {
        this.addClass(className, this.getDefaultWriter().createCopy(parentClass));
    }

    public void addClass(String className, DynamicClassWriter writer) throws DynamicException {
        DynamicClassWriter existingWriter = this.getClassWriter(className);
        if (existingWriter != null) {
            if (!existingWriter.isCompatible(writer)) {
                throw DynamicException.incompatibleDuplicateWriters(className, existingWriter, writer);
            }
        } else {
            this.getClassWriters().put(className, writer == null ? this.getDefaultWriter() : writer);
        }
    }

    public Class<?> createDynamicClass(String className, DynamicClassWriter writer) {
        this.addClass(className, writer);
        Class<?> newDynamicClass = null;
        try {
            newDynamicClass = this.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("DyanmicClassLoader: could not create class " + className);
        }
        return this.checkAssignable(newDynamicClass);
    }

    protected Class<?> checkAssignable(Class<?> clz) {
        DynamicClassWriter assignedClassWriter = this.getClassWriters().get(clz.getName());
        if (!assignedClassWriter.parentClass.isAssignableFrom(clz)) {
            throw new IllegalArgumentException("DyanmicClassLoader: " + clz.getName() + " not compatible with parent class " + assignedClassWriter.parentClass.getName());
        }
        return clz;
    }

    public Class<?> createDynamicClass(String className) {
        return this.createDynamicClass(className, this.getDefaultWriter());
    }

    public Class<?> createDynamicClass(String className, Class<?> parentClass) {
        return this.createDynamicClass(className, new DynamicClassWriter(parentClass));
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        DynamicClassWriter writer = this.getClassWriter(className);
        if (writer != null) {
            try {
                byte[] bytes = writer.writeClass(this, className);
                return this.defineClass(className, bytes, 0, bytes.length);
            }
            catch (ClassFormatError cfe) {
                throw new ClassNotFoundException(className, cfe);
            }
            catch (ClassCircularityError cce) {
                throw new ClassNotFoundException(className, cce);
            }
        }
        return super.findClass(className);
    }

    public static DynamicClassLoader lookup(Session session) {
        ConversionManager cm = null;
        cm = session == null ? ConversionManager.getDefaultManager() : session.getPlatform().getConversionManager();
        if (cm.getLoader() instanceof DynamicClassLoader) {
            return (DynamicClassLoader)cm.getLoader();
        }
        DynamicClassLoader dcl = new DynamicClassLoader(cm.getLoader());
        cm.setLoader(dcl);
        if (session == null) {
            ConversionManager.setDefaultLoader(dcl);
        }
        return dcl;
    }

    public static class EnumInfo {
        String className;
        List<String> literalLabels = new ArrayList<String>();

        public EnumInfo(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public String[] getLiteralLabels() {
            return this.literalLabels.toArray(new String[this.literalLabels.size()]);
        }

        public void addLiteralLabel(String literalLabel) {
            if (!this.literalLabels.contains(literalLabel) && literalLabel != null) {
                this.literalLabels.add(literalLabel);
            }
        }
    }
}

